---
id: fast-colors.pixelbox
title: PixelBox class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [PixelBox](./fast-colors.pixelbox.md)

## PixelBox class

Represents a range of colors in RGB color space.

<b>Signature:</b>

```typescript
export declare class PixelBox 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(globalHistogram, minRed, maxRed, minGreen, maxGreen, minBlue, maxBlue)](./fast-colors.pixelbox._constructor_.md) |  | Constructs a new instance of the <code>PixelBox</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [averageColor](./fast-colors.pixelbox.averagecolor.md) |  | [ColorRGBA64](./fast-colors.colorrgba64.md) |  |
|  [colorVolume](./fast-colors.pixelbox.colorvolume.md) |  | number |  |
|  [globalHistogram](./fast-colors.pixelbox.globalhistogram.md) |  | [Histogram](./fast-colors.histogram.md) |  |
|  [maxBlue](./fast-colors.pixelbox.maxblue.md) |  | number |  |
|  [maxGreen](./fast-colors.pixelbox.maxgreen.md) |  | number |  |
|  [maxRed](./fast-colors.pixelbox.maxred.md) |  | number |  |
|  [minBlue](./fast-colors.pixelbox.minblue.md) |  | number |  |
|  [minGreen](./fast-colors.pixelbox.mingreen.md) |  | number |  |
|  [minRed](./fast-colors.pixelbox.minred.md) |  | number |  |
|  [modifiedMedianCut](./fast-colors.pixelbox.modifiedmediancut.md) |  | () =&gt; \[[PixelBox](./fast-colors.pixelbox.md) \| null, [PixelBox](./fast-colors.pixelbox.md) \| null\] | Attempts to divide the range of colors represented by this PixelBox into two smaller PixelBox objects. This does not actually cut directly at the median, rather it finds the median then cuts halfway through the larger box on either side of that median. The result is that small areas of color are better represented in the final output. Based on the Modified Median Cut Quantization implementation from https://github.com/DanBloomberg/leptonica/blob/master/src/colorquant2.c |
|  [pixelCount](./fast-colors.pixelbox.pixelcount.md) |  | number |  |
|  [rangeBlue](./fast-colors.pixelbox.rangeblue.md) |  | number |  |
|  [rangeGreen](./fast-colors.pixelbox.rangegreen.md) |  | number |  |
|  [rangeRed](./fast-colors.pixelbox.rangered.md) |  | number |  |
