/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_DHCPSETTINGDATA_H_
#define OPENDRIM_DHCPSETTINGDATA_H_

#include <Instance.h>

const static char* OpenDRIM_DHCPSettingData_classnames[] = {"OpenDRIM_DHCPSettingData"};
static string OpenDRIM_DHCPSettingData_NAMESPACE = _NAMESPACE;

class OpenDRIM_DHCPSettingData {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	unsigned short AddressOrigin;
	bool AddressOrigin_isNULL;
	
	string RequestedIPv4Address;
	bool RequestedIPv4Address_isNULL;
	
	unsigned int RequestedLeaseTime;
	bool RequestedLeaseTime_isNULL;
	
	string ClientIdentifier;
	bool ClientIdentifier_isNULL;
	
	string VendorClassIdentifier;
	bool VendorClassIdentifier_isNULL;
	
	vector<unsigned short> RequestedOptions;
	bool RequestedOptions_isNULL;
	
	vector<unsigned short> RequiredOptions;
	bool RequiredOptions_isNULL;
	
	OpenDRIM_DHCPSettingData() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		AddressOrigin_isNULL = true;
		RequestedIPv4Address_isNULL = true;
		RequestedLeaseTime_isNULL = true;
		ClientIdentifier_isNULL = true;
		VendorClassIdentifier_isNULL = true;
		RequestedOptions_isNULL = true;
		RequiredOptions_isNULL = true;
	}
	
	~OpenDRIM_DHCPSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getAddressOrigin(unsigned short& value) const {
		if (AddressOrigin_isNULL==true)
			return NOT_FOUND;
		value = AddressOrigin;
		return OK;
	}
	
	int setAddressOrigin(const unsigned short& newValue) {
		AddressOrigin = newValue;
		AddressOrigin_isNULL = false;
		return OK;
	}

	int getRequestedIPv4Address(string& value) const {
		if (RequestedIPv4Address_isNULL==true)
			return NOT_FOUND;
		value = RequestedIPv4Address;
		return OK;
	}
	
	int setRequestedIPv4Address(const string& newValue) {
		RequestedIPv4Address = newValue;
		RequestedIPv4Address_isNULL = false;
		return OK;
	}

	int getRequestedLeaseTime(unsigned int& value) const {
		if (RequestedLeaseTime_isNULL==true)
			return NOT_FOUND;
		value = RequestedLeaseTime;
		return OK;
	}
	
	int setRequestedLeaseTime(const unsigned int& newValue) {
		RequestedLeaseTime = newValue;
		RequestedLeaseTime_isNULL = false;
		return OK;
	}

	int getClientIdentifier(string& value) const {
		if (ClientIdentifier_isNULL==true)
			return NOT_FOUND;
		value = ClientIdentifier;
		return OK;
	}
	
	int setClientIdentifier(const string& newValue) {
		ClientIdentifier = newValue;
		ClientIdentifier_isNULL = false;
		return OK;
	}

	int getVendorClassIdentifier(string& value) const {
		if (VendorClassIdentifier_isNULL==true)
			return NOT_FOUND;
		value = VendorClassIdentifier;
		return OK;
	}
	
	int setVendorClassIdentifier(const string& newValue) {
		VendorClassIdentifier = newValue;
		VendorClassIdentifier_isNULL = false;
		return OK;
	}

	int getRequestedOptions(vector<unsigned short>& value) const {
		if (RequestedOptions_isNULL==true)
			return NOT_FOUND;
		value = RequestedOptions;
		return OK;
	}
	
	int setRequestedOptions(const vector<unsigned short>& newValue) {
		RequestedOptions = newValue;
		RequestedOptions_isNULL = false;
		return OK;
	}

	int getRequiredOptions(vector<unsigned short>& value) const {
		if (RequiredOptions_isNULL==true)
			return NOT_FOUND;
		value = RequiredOptions;
		return OK;
	}
	
	int setRequiredOptions(const vector<unsigned short>& newValue) {
		RequiredOptions = newValue;
		RequiredOptions_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_DHCPSETTINGDATA_H_*/
