/*
 * stdlib.h compatibility shim
 * Public domain
 */

#ifdef _MSC_VER
#if _MSC_VER >= 1900
#include <../ucrt/stdlib.h>
#else
#include <../include/stdlib.h>
#endif
#else
#include_next <stdlib.h>
#endif

#ifndef IKED_COMPAT_STDLIB_H
#define IKED_COMPAT_STDLIB_H

#include <sys/types.h>
#include <stdint.h>

#ifndef HAVE_ARC4RANDOM_BUF
uint32_t arc4random(void);
void arc4random_buf(void *_buf, size_t n);
uint32_t arc4random_uniform(uint32_t upper_bound);
#endif

#ifndef HAVE_FREEZERO
void freezero(void *ptr, size_t sz);
#endif

#ifndef HAVE_GETPROGNAME
const char * getprogname(void);
#endif

void *reallocarray(void *, size_t, size_t);

#ifndef HAVE_RECALLOCARRAY
void *recallocarray(void *, size_t, size_t, size_t);
#endif

#ifndef HAVE_STRTONUM
long long strtonum(const char *nptr, long long minval,
		long long maxval, const char **errstr);
#endif

#endif
