//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/calls.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, imports, buffer) {
    "use asm";

    var imul = global.Math.imul;
    var sum = imports.sum;
    var max = imports.max;
    var g = 0;

    function fibonacci(x) {
        x = x | 0;
        if ((x | 0) <= 1)
            return 1;
        return ((fibonacci((x - 1) | 0) | 0) + (fibonacci((x - 2) | 0) | 0)) | 0;
    }

    function gcd(x, y) {
        x = x | 0;
        y = y | 0;
        if ((y | 0) == 0)
            return x | 0;
        return gcd(y, ((x | 0) % (y | 0)) | 0) | 0;
    }

    function lcm(x, y) {
        x = x | 0;
        y = y | 0;
        return (imul(x, y) / (gcd(x, y) | 0)) | 0;
    }

    function setG(x) {
        x = x | 0;
        g = x;
    }

    function testCallStatement(x) {
        x = x | 0;
        setG(x);
        return g | 0;
    }

    function addSubMulDiv(i, x, y) {
        i = i | 0;
        x = x | 0;
        y = y | 0;
        return addSubMulDivTable[i & 3](x, y) | 0;
    }

    function add(x, y) {
        x = x | 0;
        y = y | 0;
        return (x + y) | 0;
    }

    function sub(x, y) {
        x = x | 0;
        y = y | 0;
        return (x - y) | 0;
    }

    function mul(x, y) {
        x = x | 0;
        y = y | 0;
        return imul(x, y);
    }

    function div(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) / (y | 0)) | 0;
    }

    function callSum(x, y) {
        x = x | 0;
        y = y | 0;
        return sum(x | 0, y | 0) | 0;
    }

    function callMax(x, y) {
        x = x | 0;
        y = y | 0;
        return max(x | 0, y | 0) | 0;
    }

    var addSubMulDivTable = [add, sub, mul, div];

    return {
        fibonacci: fibonacci,
        gcd: gcd,
        lcm: lcm,
        testCallStatement: testCallStatement,

        addSubMulDiv: addSubMulDiv,

        callSum: callSum,
        callMax: callMax,
    };
}
*/

var imports = {
    sum: (x, y) => x + y,
    max: Math.max,
};
var module = loadWebAssembly("wasm/calls.wasm", imports);

shouldBe(module.fibonacci(10), 89);
shouldBe(module.gcd(15, 25), 5);
shouldBe(module.lcm(15, 25), 75);
shouldBe(module.testCallStatement(42), 42);

shouldBe(module.addSubMulDiv(0, 6, 2), 8);
shouldBe(module.addSubMulDiv(1, 6, 2), 4);
shouldBe(module.addSubMulDiv(2, 6, 2), 12);
shouldBe(module.addSubMulDiv(3, 6, 2), 3);
shouldBe(module.addSubMulDiv(4, 6, 2), 8);
shouldBe(module.addSubMulDiv(10, 6, 2), 12);
shouldBe(module.addSubMulDiv(-1, 6, 2), 3);

shouldBe(module.callSum(1, 2), 3);
shouldBe(module.callMax(1, 2), 2);
