/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package xmlObjects;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;

import org.w3c.dom.NodeList;

import help.Config;
import help.Convertions;
import help.Text;
import grpFilt.GrpFiltWidget;

/*******
 * 
 * This Class contains all informations given by gui_vtsetup.xml. 
 */
public class VtEnv {
	
	
	/****
	 * List of all Groups
	 */
	private static ArrayList<Group> groups = new ArrayList<Group>();
	/****
	 * List of all Items
	 */
	private ArrayList<Item> items = new ArrayList<Item>();
	/*****
	 * List of all enums
	 */
	private ArrayList<EnumClass> enumlst = new ArrayList<EnumClass>();
	/*****
	 * list of all enumSelections
	 */
	private ArrayList<EnumSelectionClass> enumselectlst = new ArrayList<EnumSelectionClass>();
	private String vtenvversion = "";
	private String vtversion = "";
	public String arguments = "";
	public static JEditorPane UserManualView = new JEditorPane();
	public static ArrayList<String> visitedLinks = new ArrayList<String>();
	public static int LinkPointer = 0;
	public JEditorPane ToolTipView = new JEditorPane();
	public static String srcFolder = "/src/";
	public static int caretPos = 0;
	public static JFrame infoBox = null;
	private static String UserManualPath = null;
	private static JViewport toolTip = null;
	public boolean hasChanged = false;
	public String executable = "";
	public String Lexecutable = "";
	public boolean executableLoaded = false;
	public static int executableAnswer = 4;
	public static Text mytext = null;
	public static JEditorPane menu = null;
	public static String nm = "";
	public static int maxLabelWidth = 0;
	public static int maxLabelWidth_adv = 0;
	/***
	 * Component of type {@link GrpFiltWidget GrpFiltWidget}
	 */
	private GrpFiltWidget grpFiltWidget = null; 
	
	/****
	 * Get all Information about the vampirTrace environment variables from the 
	 * gui_VTSetup.xml file and put this informations into the Lists.
	 */
	public VtEnv(Text mytext,String filePath,String configFile, String userManualPath)
	{
		this.UserManualPath = userManualPath;
		this.mytext = mytext;
		ArrayList<Group> groups = new ArrayList<Group>();
		ArrayList<EnumClass> enumlst = new ArrayList<EnumClass>();
		ArrayList<EnumSelectionClass> enumselectlst = new ArrayList<EnumSelectionClass>();
		
		InputStream in;
		try {
			in = new FileInputStream(configFile);
			DocumentBuilderFactory factory  = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder  = factory.newDocumentBuilder();
			org.w3c.dom.Document doc = builder.parse(in);
			NodeList liste = doc.getElementsByTagName("vtconfig");
			vtenvversion = liste.item(0).getAttributes().getNamedItem("vtconfigversion").getNodeValue();
			in.close();
		} catch (Exception e) {

			Config.errorHandler(e);
		}
		
		//Values groups
		String currentVal = new String();
		Group newGroup = null;
		String id = new String();
		String name = new String();
		String parentId = new String();
		int priorety;
		
		//Values items
		String envname = "";
		String groupName = "";
		boolean isadvanced=false,isdeprecated=false;
		
		
		
		Item newItem = new Item(false, 999,new String(),false, newGroup, new String());
		
		// First create a new XMLInputFactory and set up EventHandler
		try{
			XMLInputFactory inputFactory = XMLInputFactory.newInstance();
			
			in = null;
			
			//try "etc" dir from vampirtrace
			try{
				in = new FileInputStream(filePath);
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
			
			
			XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
			
			
			XMLEvent event;
			
			//reading the xmlFile
			while (eventReader.hasNext()) {
				//get next XML-tag
				event = eventReader.nextEvent();
				if(event == null)
					break;
				
					//StartTags and Elements
				if(event.isStartElement())
				{	
					if(event.asStartElement().asStartElement().getName().toString().compareTo("vtenv")==0)
					{
						//this.vtenvversion=event.asStartElement().asStartElement().getAttributeByName(new QName("vtenvversion")).getValue();
						this.vtversion=event.asStartElement().asStartElement().getAttributeByName(new QName("vtversion")).getValue();
					}
					
					//*******START get GROUPS ********** / 
					if(event.asStartElement().asStartElement().getName().toString().compareTo("group")==0)
					{
						//get Attributes
						id =  event.asStartElement().asStartElement().getAttributeByName(new QName("identifier")).getValue();
						name =  event.asStartElement().asStartElement().getAttributeByName(new QName("descname")).getValue();
						
						if(event.asStartElement().asStartElement().getAttributeByName(new QName("priority")).getValue().trim().compareTo("") == 0)
							priorety = 999;
						else
							priorety = Integer.parseInt(event.asStartElement().asStartElement().getAttributeByName(new QName("priority")).getValue());
						
						//set new Group
						newGroup = new Group(id,name,priorety,this);
						currentVal = "group";
					}

					if(currentVal.compareTo("group") == 0)
					{
						//Get Group description
						if(event.isStartElement() &&event.asStartElement().getName().toString().compareTo("desc")==0)
						{
							//set description of the group
							event = eventReader.nextEvent();
							newGroup.setDesc(event.asCharacters().getData());		
						}
						
						//Get Group parentId
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("parentid")==0)
						{
							event = eventReader.nextEvent();
							parentId = event.asCharacters().getData();
							if(parentId.trim().compareTo("") != 0)
								newGroup.setHasParent(true);
						}
					}
					//*******END get GROUPS ********** /
					
					
				
					//*******START get ITEMS *********** /
					if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("env")==0)
					{
						
						currentVal = "item";
						
						name = event.asStartElement().asStartElement().getAttributeByName(new QName("descname")).getValue();
						envname = event.asStartElement().asStartElement().getAttributeByName(new QName("envname")).getValue();
						groupName = event.asStartElement().asStartElement().getAttributeByName(new QName("group")).getValue();
						
						if(event.asStartElement().asStartElement().getAttributeByName(new QName("priority")).getValue().trim().compareTo("") == 0)
							priorety = 999;
						else
							priorety = Integer.parseInt(event.asStartElement().asStartElement().getAttributeByName(new QName("priority")).getValue());
						 
						if(event.asStartElement().asStartElement().getAttributeByName(new QName("isdeprecated")).getValue().trim().compareTo("1") == 0)
							 isdeprecated = true;
						else 
							 isdeprecated = false;
						
						if(event.asStartElement().asStartElement().getAttributeByName(new QName("isadvanced")).getValue().trim().compareTo("1") == 0)
							 isadvanced = true;
						else 
							 isadvanced = false;
						//Find Group
						newGroup = null;
						for(int i=0;i<groups.size();i++)
						{
							if(groups.get(i).getId().trim().compareTo(groupName.trim())==0)
							{
								newGroup = groups.get(i);
							}
							for(int j=0;j<groups.get(i).getSubGroups().size();j++)
							{
								if(groups.get(i).getSubGroups().get(j).getId().trim().compareTo(groupName.trim())==0)
								{
									newGroup = groups.get(i).getSubGroups().get(j);
								}
							}
						}
						
						//create new Item
						newItem = new Item(isdeprecated, priorety,name,isadvanced, newGroup, envname);		
						
					}
					
					
					if(currentVal.compareTo("item")==0)
					{
						
						// Get Item description
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("desc")==0)
						{
							event = eventReader.nextEvent();
							newItem.setDesc(event.asCharacters().getData());
	
						}
						
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("warning")==0)
						{
							event = eventReader.nextEvent();
							newItem.setWarning(event.asCharacters().getData());
		
						}
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("available")==0)
						{
							event = eventReader.nextEvent();
							if(event.asCharacters().getData().trim().compareTo("1")==0)
								newItem.setAvailable(true);
							else
								newItem.setAvailable(false);

						}
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("anchor")==0)
						{
							event = eventReader.nextEvent();
							newItem.setAnchor(event.asCharacters().getData());

						}
						
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("since")==0)
						{
							newItem.setMajorSince(Integer.parseInt(event.asStartElement().asStartElement().getAttributeByName(new QName("major")).getValue()));
							newItem.setMinorSince(Integer.parseInt(event.asStartElement().asStartElement().getAttributeByName(new QName("minor")).getValue()));
							newItem.setPatchSince(Integer.parseInt(event.asStartElement().asStartElement().getAttributeByName(new QName("patch")).getValue()));
						}
						
						//******** Value description ******** /
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("valuedesc")==0)
						{
							while(!(event.isEndElement() && event.asEndElement().getName().toString().compareTo("valuedesc")==0))
							{
								event = eventReader.nextEvent();
								if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("value") == 0)
								{
									String type = new String(event.asStartElement().getAttributeByName(new QName("type")).getValue());
									ValDesc newValDesc = new ValDesc();
									newValDesc.setType(type);
									while(!(event.isEndElement() && event.asEndElement().getName().toString().compareTo("value")==0))
									{
										event = eventReader.nextEvent();
										//get default
										if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("default") == 0)
										{
	
											event = eventReader.nextEvent();
											if(event.isCharacters())
												newValDesc.setDefault(event.asCharacters().getData());
											
		
										}
										//get range
										if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("range") == 0)
										{
											newValDesc.setMax(Convertions.getDouble(event.asStartElement().getAttributeByName(new QName("max")).getValue()));
											newValDesc.setMin(Convertions.getDouble(event.asStartElement().getAttributeByName(new QName("min")).getValue()));
											
										}
										
										if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("enumid") == 0)
										{
											event = eventReader.nextEvent();
											newValDesc.setEnumId(event.asCharacters().getData());
										}
										
										if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("io") == 0)
										{
											event = eventReader.nextEvent();
											newValDesc.setIObehavior(event.asCharacters().getData());
										}
										
										if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("noDefault") == 0)
										{
											event = eventReader.nextEvent();
											if(event.asCharacters().getData().compareTo("1")==0)
												newValDesc.setNoDefault(true);
											else
												newValDesc.setNoDefault(false);
											
										}
										
									}
								
									newItem.addValue(newValDesc);
								}
								
							}
						}
					}				
					//*******END get ITEMS ************* /
					 
					
					//*******START get ENUMS ********** / 
					if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("enum")==0)
					{
						currentVal = "enum";
						enumlst.add(new EnumClass(event.asStartElement().getAttributeByName(new QName("id")).getValue()));
					}
					if(currentVal.compareTo("enum") == 0)
					{
						if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("entry")==0)
						{
							event = eventReader.nextEvent();
							enumlst.get(enumlst.size()-1).getEntrys().add(event.asCharacters().getData());
						}
					}
					//*********END get ENUMS *********** /
					
					//*******START get ENUMSELECT ********** / 
					if(event.isStartElement() && event.asStartElement().getName().toString().compareTo("enumselection")==0)
					{
						currentVal = "enumSelection";
						if(event.asStartElement().getAttributeByName(new QName("oneRequired")).getValue().compareTo("0")==0)
							enumselectlst.add(new EnumSelectionClass(event.asStartElement().getAttributeByName(new QName("id")).getValue(), false));
						else
							enumselectlst.add(new EnumSelectionClass(event.asStartElement().getAttributeByName(new QName("id")).getValue(), true));
					}
					if(currentVal.compareTo("enumSelection") == 0)
					{
						if(event.isStartElement() && event.asStartElement().asStartElement().getName().toString().compareTo("entry")==0)
						{
							event = eventReader.nextEvent();
							enumselectlst.get(enumselectlst.size()-1).getEntrys().add(event.asCharacters().getData());
						}
					}
					//*********END get ENUMSELECT *********** /
				}
		
				if(event.isEndElement())
				{
					//end of group
					if(currentVal.compareTo("group") == 0 && event.asEndElement().getName().toString().compareTo("group") == 0)
					{
						if(parentId.trim().compareTo("") == 0)
						{
							
							//Add group by priority
							int k=0;
							for(k=0;k<(groups.size());k++)
							{
								if(groups.get(k).getPriority() > newGroup.getPriority())
									break;
							}
							groups.add(k,newGroup);
						}
						else
						{
							for(int i=0;i<groups.size();i++)
							{
								if(groups.get(i).getId().trim().compareTo(parentId.trim())==0)
								{
									//add subgroup by priority
									int k=0;
									for(k=0;k<(groups.get(i).getSubGroups().size());k++)
									{
										if(groups.get(i).getSubGroups().get(k).getPriority() > newGroup.getPriority())
											break;
									}
									groups.get(i).getSubGroups().add(k,newGroup);
								}
							}
						}
						parentId = "";
						currentVal = "";
					}
					
					//end of Item
					if(currentVal.compareTo("item") == 0 && event.asEndElement().getName().toString().compareTo("env") == 0)
					{
						if(newItem.getGroup() != null)
						{
							int k=0;
							for(k=0;k<newItem.getGroup().getItems().size();k++)
							{
								if(newItem.getGroup().getItems().get(k).getPriority() > newItem.getPriority())
									break;
							}
							newItem.getGroup().addItems(k,newItem);
							this.items.add(newItem);
						}
						currentVal = "";
					}
					
					
				}
				
			
			}
		
		}catch (Exception e)
		{
			Config.errorHandler(e);
		}

		this.groups = groups;
		this.enumlst = enumlst;
		this.enumselectlst = enumselectlst;
	}

	/****
	 * returns a List of all groups
	 * @return A list of all groups except subgroups
	 */
	
	public ArrayList<Group> getGroups()
	{
		return this.groups;
	}
	
	/****
	 * returns a List of all Items
	 * @return A list of all Items
	 */
	public ArrayList<Item> getItems()
	{
		return this.items;
	}
	
	
	/****
	 * returns a List of all groups
	 * @return A list of all groups and subgroups.
	 */
	public ArrayList<Group> getAllGroups()
	{
		ArrayList<Group> allGroups = new ArrayList<Group>();
		for(int i=0;i<this.groups.size();i++)
		{
			allGroups.add(this.groups.get(i));
			for(int j=0;j<this.groups.get(i).getSubGroups().size();j++)
			{
				allGroups.add(this.groups.get(i).getSubGroups().get(j));
			}
		}
		return allGroups;
	}
	
	public String getVtenversion(){
		return this.vtenvversion;
	}
	
	public String getVtversion(){
		return this.vtversion;
	}
	
	public ArrayList<EnumClass> getEnums()
	{
		return this.enumlst;
	}
	
	public ArrayList<EnumSelectionClass> getEnumSelection()
	{
		return this.enumselectlst;
	}
	
	
	/***
	 * @param id Id of a group
	 * @return the group with the given id
	 */
	public Group getGroupById(String id)
	{
		try
		{
			for(int i=0;i<this.groups.size();i++)
			{
				if(this.groups.get(i).getId().compareTo(id) == 0)
					return this.groups.get(i);
				for(int j=0;j<this.groups.get(i).getSubGroups().size();j++)
				{
					if(this.groups.get(i).getSubGroups().get(j).getId().compareTo(id) == 0)
						return this.groups.get(i).getSubGroups().get(j);
				}
			}
			
			return null;
		
		}catch(Exception e)
		{
			Config.errorHandler(e);
			return null;
		}
	}

	/***
	 * @param id Id of an Enumeration 
	 * @return the enum with the given id
	 */
	public EnumClass getEnumById(String id)
	{
		for(int i=0;i<this.enumlst.size();i++)
		{
			if(this.enumlst.get(i).getId().compareTo(id) == 0)
				return this.enumlst.get(i);
		}
		
		return null;
	}

	/***
	 * @param id Id of an Enumeration 
	 * @return the enumSelection with the given id
	 */
	public EnumSelectionClass getEnumSelectionById(String id)
	{
		for(int i=0;i<this.enumselectlst.size();i++)
		{
			if(this.enumselectlst.get(i).getId().compareTo(id) == 0)
				return this.enumselectlst.get(i);
		}
		
		return null;
	}
	
	public void setToolTip(JViewport toolTip)
	{
		this.toolTip = toolTip;
	}
	
	public JViewport getToolTip()
	{
		return this.toolTip;
	}

	
	/****
	 * Creates a html sourceCode with links to all Groups.
	 * This Source Code is used by the left menu in launch class
	 * @return Returns the html code of the menu in launch class
	 */
	public static String getMenu(boolean advanced,Group curPage,String group)
	{
		JPanel help = new JPanel();
		String currentColor = "rgb("+help.getBackground().getRed()+","+help.getBackground().getGreen()+","+help.getBackground().getBlue()+");";
		String menu = "<html><head> <style type=\"text/css\"> body{background-color:#FFFFFF; color:#000000;} h3 {color:#000000;} .current {color:#BB0000;font-weight:600;background-color:"+currentColor +";margin:0px;padding:0px;outline:none;} a{color:#000000; text-decoration:none; font-weight:600} ul{ marigin:0px; padding:0px;}</style></head><body>";
		menu += "<b>"+mytext.getText("left_Menu_headline")+"</b><ul  style=\"margin-left: 20px;\">";
		for(int i=0;i< groups.size();i++)
		{
			
				try{
					if((advanced && groups.get(i).hasadvancedview) || (!advanced && groups.get(i).hasdefaultview))
						if(curPage != null && groups.get(i).getId().trim().equals(curPage.getId().trim()))
							menu += "<div class=\"current\"><li><a class=\"current\" href=\""+groups.get(i).getId()+"\" title=\"\" ><u>"+groups.get(i).getName()+"</u></a></li></div>";
						else
							if(groups.get(i).getId().equals("FiltGrp") &&group != null && (group.trim().equals("general") ||group.trim().equals("grouping") ||group.trim().equals("filtering")))
								menu += "<div class=\"current\"><li><a href=\""+groups.get(i).getId()+"\" title=\"\" >"+groups.get(i).getName()+"</a></li>";
							else
								if(groups.get(i).getId().equals("FiltGrp"))
									menu += "<div><li><a href=\""+groups.get(i).getId()+"\" title=\"\" >"+groups.get(i).getName()+"</a></li>";
								else
									menu += "<div><li><a href=\""+groups.get(i).getId()+"\" title=\"\" >"+groups.get(i).getName()+"</a></li></div>";
				
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
			
			
			
			
			// FILTER GROUPING SPECIAL
			try{
				if(groups.get(i).getId().toString().equals("FiltGrp"))
				{
					if(group != null && (group.trim().equals("general") ||group.trim().equals("grouping") ||group.trim().equals("filtering")))
						menu += "<ul style=\"margin-left: 20px;\">";
					else
						menu += "<ul style=\"margin-left: 20px;\">";
					
					if(group != null && group.trim().equals("general"))
						menu += "<li style=\"list-style-type:square;margin-Top: 20px;\"><a class=\"current\" href=\"FiltGrp_General\" title=\""+mytext.getText("left_Menu_fltGrp_General_title")+"\" ><u>"+mytext.getText("left_Menu_fltGrp_General")+"</u></a></li>";
					else
						menu += "<li style=\"list-style-type:square;margin-Top: 20px;\"><a href=\"FiltGrp_General\" title=\""+mytext.getText("left_Menu_fltGrp_General_title")+"\" >"+mytext.getText("left_Menu_fltGrp_General")+"</a></li>";
					if(group != null && group.trim().equals("grouping"))
						menu += "<li style=\"list-style-type:square;margin-top: 20px;\"><a class=\"current\" href=\"FiltGrp_Grouping\" title=\""+mytext.getText("left_Menu_fltGrp_Grouping_title")+"\" ><u>"+mytext.getText("left_Menu_fltGrp_Grouping")+"</u></a></li>";
					else
						menu += "<li style=\"list-style-type:square;margin-top: 20px;\"><a href=\"FiltGrp_Grouping\" title=\""+mytext.getText("left_Menu_fltGrp_Grouping_title")+"\" >"+mytext.getText("left_Menu_fltGrp_Grouping")+"</a></li>";
					if(group != null && group.trim().equals("filtering"))
						menu += "<li style=\"list-style-type:square;margin-top: 20px;\"><a class=\"current\" href=\"FiltGrp_Filtering\" title=\""+mytext.getText("left_Menu_fltGrp_Filtering_title")+"\" ><u>"+mytext.getText("left_Menu_fltGrp_Filtering")+"</u></a></li>";
					else
						menu += "<li style=\"list-style-type:square;margin-top: 20px;\"><a href=\"FiltGrp_Filtering\" title=\""+mytext.getText("left_Menu_fltGrp_Filtering_title")+"\" >"+mytext.getText("left_Menu_fltGrp_Filtering")+"</a></li>";
					
					menu += "</ul></div>";
				}
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}
			
			menu += "";
		}
		menu += "</ul></body></html>";
		return menu;
	}

	/***
	* returns an Item what is searched by Id 
	* @param id id or environment name of the searched item
 	* @return item with the specified id
 	*/
	public Item getItemById(String id)
	{
		Item out = null;
		for(int i=0;i<items.size();i++)
		{
			if(items.get(i).getEnvname().trim().equals(id.trim()))
				out = items.get(i);
		}
		
		return out;
	}
	
	
	public void setGrpFiltWidget(GrpFiltWidget grpFiltWidget)
	{
		this.grpFiltWidget = grpFiltWidget;
	}
	
	public GrpFiltWidget getGrpFiltWidget()
	{
		return this.grpFiltWidget;
	}
	
	public static String getUserManualPath()
	{
		return UserManualPath;
	}
	
	/***
	 * Creates a tooltip window
	 */
	public static void windowing()
	{
		infoBox = new JFrame("User Manual");
		infoBox.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		infoBox.setPreferredSize(new Dimension(700,500));
		infoBox.setMinimumSize(new Dimension(450,450));
		infoBox.setIconImage(new ImageIcon(Group.class.getClass().getResource(srcFolder+Config.Image_BROWSER)).getImage());
		JScrollPane pane = new JScrollPane(UserManualView);
		JPanel panel = new JPanel(new BorderLayout());
		final JEditorPane menu = new JEditorPane();
		menu.setSize(600, 40);
		menu.setEditable(false);
		menu.setFocusable(false);
		menu.addCaretListener(new CaretListener()
		{
			public void caretUpdate(CaretEvent arg0) {;}
		});

		
		final String all_text = "<html>" + 
				      "<head> <style type=\"text/css\"> body{background-color:#EEEEEE; color:#000000;}a{ text-decoration:none; font-weight:600} </style></head>"+
				      "<body>"+
				      "<table border=\"0\" width=\"100%\"><tr><td align=\"center\"><a  href=\"prev\" title=\"Previus\"><img border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_BACK)+"\" alt=\"Previus\" /></a> &nbsp;&nbsp;&nbsp; "+
				      "<a href=\"next\" title=\"Next\"><img  border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_Forward)+"\" alt=\"Next\" /></a></td>" +
				      "<td align=\"center\"><a href=\"SECTION00100000000000000000\" title=\"Contents\">Contents</a></td>"+
				      "<td align=\"center\"><a href=\"SECTION00420000000000000000\" title=\"Enviromentels\">Environment Variables</a></td>"+
				      "</tr></table>" +
				      "</body>"+
					  "</html>";
		final String noleft_text = "<html>" + 
	      "<head> <style type=\"text/css\"> body{background-color:#EEEEEE; color:#000000;}a{ text-decoration:none; font-weight:600} </style></head>"+
	      "<body>"+
	      "<table border=\"0\" width=\"100%\"><tr><td align=\"center\"><img border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_BACKg)+"\" alt=\"Previus\" /> &nbsp;&nbsp;&nbsp; "+
	      "<a href=\"next\" title=\"Next\"><img  border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_Forward)+"\" alt=\"Next\" /></a></td>" +
	      "<td align=\"center\"><a href=\"SECTION00100000000000000000\" title=\"Contents\">Contents</a></td>"+
	      "<td align=\"center\"><a href=\"SECTION00420000000000000000\" title=\"Enviromentels\">Environment Variables</a></td>"+
	      "</tr></table>" +
	      "</body>"+
		  "</html>";
		final String noright_text = "<html>" + 
	      "<head> <style type=\"text/css\"> body{background-color:#EEEEEE; color:#000000;}a{ text-decoration:none; font-weight:600} </style></head>"+
	      "<body>"+
	      "<table border=\"0\" width=\"100%\"><tr><td align=\"center\"><a  href=\"prev\" title=\"Previus\"><img border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_BACK)+"\" alt=\"Previus\" /></a> &nbsp;&nbsp;&nbsp; "+
	      "<img  border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_Forwardg)+"\" alt=\"Next\" /></td>" +
	      "<td align=\"center\"><a href=\"SECTION00100000000000000000\" title=\"Contents\">Contents</a></td>"+
	      "<td align=\"center\"><a href=\"SECTION00420000000000000000\" title=\"Enviromentels\">Environment Variables</a></td>"+
	      "</tr></table>" +
	      "</body>"+
		  "</html>";
		final String noboth_text = "<html>" + 
	      "<head> <style type=\"text/css\"> body{background-color:#EEEEEE; color:#000000;}a{ text-decoration:none; font-weight:600} </style></head>"+
	      "<body>"+
	      "<table border=\"0\" width=\"100%\"><tr><td align=\"center\"><img border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_BACKg)+"\" alt=\"Previus\" /> &nbsp;&nbsp;&nbsp; "+
	      "<img  border=\"0\" src=\""+VtEnv.class.getClass().getResource(srcFolder+Config.Image_BROWSER_Forwardg)+"\" alt=\"Next\" /></td>" +
	      "<td align=\"center\"><a href=\"SECTION00100000000000000000\" title=\"Contents\">Contents</a></td>"+
	      "<td align=\"center\"><a href=\"SECTION00420000000000000000\" title=\"Enviromentels\">Environment Variables</a></td>"+
	      "</tr></table>" +
	      "</body>"+
		  "</html>";
		
		menu.setContentType("text/html");
		menu.setEditable(false);  
		menu.setText(noboth_text);
		menu.addHyperlinkListener(new HyperlinkListener(){

			public void hyperlinkUpdate(HyperlinkEvent e) {
				if(e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
				{
					String url = e.getDescription().trim();
					if(!url.toLowerCase().equals("prev") && !url.toLowerCase().equals("next"))
					{
						try{
							while(visitedLinks.size()>LinkPointer+1)
								visitedLinks.remove(LinkPointer+1);
							visitedLinks.add("file://"+getUserManualPath()+"#"+url);
							LinkPointer = visitedLinks.size() -1;
							UserManualView.setPage("file://"+getUserManualPath()+"#"+url);
							
						}catch(Exception ex)
						{
							Config.errorHandler(ex);
						}
					}
					
					if(url.equals("prev") && LinkPointer >= 1)
					{
						try{
							LinkPointer=LinkPointer-1;
							UserManualView.setPage(visitedLinks.get(LinkPointer));
						}catch(Exception ex)
						{
							Config.errorHandler(ex);
						}
					}
					
					if(url.equals("next") && LinkPointer < (visitedLinks.size())-1)
					{
						try{
							LinkPointer=LinkPointer+1;
							UserManualView.setPage(visitedLinks.get(LinkPointer));
						}catch(Exception ex)
						{
							Config.errorHandler(ex);
						}
					}
					
				}
			}});
		panel.add(menu,BorderLayout.NORTH);
	
		panel.add(pane,BorderLayout.CENTER);
	
		infoBox.add(panel);
		infoBox.setVisible(true);
		infoBox.pack();
		
		UserManualView.addPropertyChangeListener(new PropertyChangeListener(){

			
			public void propertyChange(PropertyChangeEvent e) {

				if(e.getPropertyName().equals("page"))
				{
					int i = 0;
					int k = visitedLinks.size();
					int j = (LinkPointer+1);
					if(0 == j-1)
						i=i+1;
					if(k <= j)
						i=i+2;
					switch(i)
					{
					case 0: if(!menu.getText().equals(all_text)) menu.setText(all_text);
					break;
					case 1: if(!menu.getText().equals(noleft_text)) menu.setText(noleft_text);
					break;
					case 2: if(!menu.getText().equals(noright_text)) menu.setText(noright_text);
					break;
					case 3: if(!menu.getText().equals(noboth_text)) menu.setText(noboth_text);
					break;
					}
				}
			}
			
		});
		UserManualView.addHyperlinkListener(new HyperlinkListener(){

			public void hyperlinkUpdate(HyperlinkEvent e) {
				if(e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
				{
					try {
						if(e.getDescription().startsWith("#"))
						{
							while(visitedLinks.size()>LinkPointer+1)
								visitedLinks.remove(LinkPointer+1);
							visitedLinks.add("file://"+getUserManualPath()+e.getDescription());
							LinkPointer = visitedLinks.size() -1;
							UserManualView.setPage("file://"+getUserManualPath()+e.getDescription());
						}
					} catch (IOException ex) {
						Config.errorHandler(ex);
					}

					
				}
				
			}
			
		});
		
		infoBox.addComponentListener(new ComponentListener(){

			
			public void componentHidden(ComponentEvent e) {;}

			
			public void componentMoved(ComponentEvent e) {;}

			
			public void componentResized(ComponentEvent e) {
				try{
					UserManualView.setPage(UserManualView.getPage());
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
				
			}

			
			public void componentShown(ComponentEvent e) {;}
			
		});
	}
	
}
