##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
import LSCGenerator
import commands
import os


class LSCGeneratorTestCase(unittest.TestCase):

    ## Initial Set UP
    lsc_gen_obj = LSCGenerator.LSCGenerator()
    cwd = os.getcwd()

    def test_setUp1(self):
        print "\nTesting LSCGenerator Test Suite ..."
        req_out_put = None

        build_path = './test/unit_test/work/output/'
        out_put = self.lsc_gen_obj.setUp(build_path)
        self.assertEquals(out_put, req_out_put)


    def test_setUp2(self):
        req_out_put = None

        build_path = './test/unit_test/work/output/'
        out_put = self.lsc_gen_obj.setUp(build_path)
        self.assertEquals(out_put, req_out_put)

        import commands
        commands.getoutput('rm -rf ' + build_path + 'IdCache')
        commands.getoutput('rm -rf ' + build_path + 'HtmlCache')


    def test_createDir1(self):
        req_out_put = None

        build_path = './test/unit_test/work/output/'
        out_put = self.lsc_gen_obj._createDir(build_path)
        self.assertEquals(out_put, req_out_put)


    def test_createDir2(self):
        req_out_put = None

        build_path = './test/unit_test/work/output/tmp'
        out_put = self.lsc_gen_obj._createDir(build_path)
        self.assertEquals(out_put, req_out_put)
        commands.getoutput('rm -rf ' + './test/unit_test/work/output/tmp')


    def test_readConfAndGetBuildPath(self):
        req_out_put = './unit_test_build/'

        path = './test/unit_test/work/input/'
        conf_file = 'lsc1.conf'
        setattr(self.lsc_gen_obj, 'cwd', path)
        setattr(LSCGenerator, 'config_file', conf_file)
        out_put = self.lsc_gen_obj._readConfAndGetBuildPath()
        self.assertEquals(out_put, req_out_put)


    def test_sanityTestSetUp(self):
        req_out_put = None

        path = './unit_test_build'
        if not os.path.exists(path):
            os.mkdir(path)

        from test import sanity_test
        sanity_test_obj = sanity_test.SanityTest()

        conf_file = 'lsc1.conf'
        path = './test/unit_test/work/input/'
        setattr(self.lsc_gen_obj, 'cwd', path)
        setattr(LSCGenerator, 'config_file', conf_file)
        out_put = self.lsc_gen_obj._sanityTestSetUp(sanity_test_obj)
        self.assertEquals(out_put, req_out_put)

        commands.getoutput('rm -rf ' + './unit_test_build')


    def test_mantisReportSetUp(self):
        req_out_put = None

        path = './test/unit_test/work/input/'
        conf_file = 'lsc1.conf'
        setattr(self.lsc_gen_obj, 'cwd', path)
        setattr(LSCGenerator, 'config_file', conf_file)
        self.lsc_gen_obj._readConfAndGetBuildPath()

        from test import sanity_test
        sanity_test_obj = sanity_test.SanityTest()
        setattr(self.lsc_gen_obj, 'mantis_obj', sanity_test)
        out_put = self.lsc_gen_obj._mantisReportSetUp()
        self.assertEquals(out_put, req_out_put)


    def test_helpMsg(self):
        req_out_put = None

        out_put = LSCGenerator.helpMsg()
        self.assertEquals(out_put, req_out_put)


    def test_commonMsg(self):
        req_out_put = None

        out_put = LSCGenerator.commonMsg()
        self.assertEquals(out_put, req_out_put)



if __name__ == '__main__':
    unittest.main()
