# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1800-1 (linux-2.6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64034);
 script_cve_id("CVE-2009-0028", "CVE-2009-0834", "CVE-2009-0835", "CVE-2009-0859", "CVE-2009-1046", "CVE-2009-1072", "CVE-2009-1184", "CVE-2009-1192", "CVE-2009-1242", "CVE-2009-1265", "CVE-2009-1337", "CVE-2009-1338", "CVE-2009-1439");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1800-1 (linux-2.6)";
 script_name(name);

 desc = "The remote host is missing an update to linux-2.6
announced via advisory DSA 1800-1.

Several vulnerabilities have been discovered in the Linux kernel that
may lead to a denial of service, privilege escalation or a sensitive
memory leak. For details, please visit the referenced security
advisories.

For the stable distribution (lenny), these problems have been fixed in
version 2.6.26-15lenny2.

For the oldstable distribution (etch), these problems, where applicable,
will be fixed in future updates to linux-2.6 and linux-2.6.24.

We recommend that you upgrade your linux-2.6 and user-mode-linux packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201800-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1800-1 (linux-2.6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-support-2.6.26-2", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.26", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.26", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.26", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.26", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc-2.6.26", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-legacy", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-legacy", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-generic", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-alpha", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-xen", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-openvz", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-vserver", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-amd64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"user-mode-linux", ver:"2.6.26-1um-2+15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-orion5x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-ixp4xx", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-footbridge", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-orion5x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-footbridge", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-ixp4xx", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-iop32x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-arm", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-iop32x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-versatile", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-armel", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-versatile", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-hppa", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686-bigmem", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-486", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686-bigmem", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-i386", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-486", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-mckinley", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-mckinley", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-mckinley", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-mckinley", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-itanium", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-ia64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-itanium", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-itanium", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-itanium", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-5kc-malta", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sb1-bcm91250a", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sb1a-bcm91480b", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sb1-bcm91250a", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-4kc-malta", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r4k-ip22", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sb1a-bcm91480b", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-mips", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r5k-ip32", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-5kc-malta", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r4k-ip22", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r5k-ip32", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-4kc-malta", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-mipsel", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r5k-cobalt", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r5k-cobalt", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-powerpc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-s390x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-s390x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-s390", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390-tape", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-s390x", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-s390", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-sparc", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-sparc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sparc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sparc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-sparc64", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sparc64-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sparc64-smp", ver:"2.6.26-15lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
