# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1903-1 (graphicsmagick)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65746);
 script_cve_id("CVE-2007-1667", "CVE-2007-1797", "CVE-2007-4985", "CVE-2007-4986", "CVE-2007-4988", "CVE-2008-1096", "CVE-2008-3134", "CVE-2008-6070", "CVE-2008-6071", "CVE-2008-6072", "CVE-2008-6621", "CVE-2009-1882");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1903-1 (graphicsmagick)");

 desc = "The remote host is missing an update to graphicsmagick
announced via advisory DSA 1903-1.

Several vulnerabilities have been discovered in graphicsmagick, a
collection of image processing tool, which can lead to the execution
of arbitrary code, exposure of sensitive information or cause DoS.
For details on the issuess addressed, please visit the referenced
security advisories.

For the oldstable distribution (etch), these problems have been fixed in
version 1.1.7-13+etch1.

For the stable distribution (lenny), these problems have been fixed in
version 1.1.11-3.2+lenny1.

For the upcoming stable distribution (squeeze) and the unstable
distribution ion (sid), these problems have been fixed in version
1.3.5-5.1.

We recommend that you upgrade your graphicsmagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201903-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1903-1 (graphicsmagick)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"graphicsmagick-libmagick-dev-compat", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick-imagemagick-compat", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick1-dev", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick1", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphics-magick-perl", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick-dbg", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick++1", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick++1-dev", ver:"1.1.7-13+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick-imagemagick-compat", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick-libmagick-dev-compat", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick++1", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick1-dev", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphics-magick-perl", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick1", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgraphicsmagick++1-dev", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"graphicsmagick-dbg", ver:"1.1.11-3.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
