# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 963-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56241);
 script_cve_id("CVE-2006-0351");
 script_bugtraq_id(16431);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 963-1 (mydns)";
 script_name(name);

 desc = "The remote host is missing an update to mydns
announced via advisory DSA 963-1.

NISCC reported that MyDNS, a DNS server using an SQL database for data
storage, can be tricked into an infinite loop by a remote attacker and
hence cause a denial of service condition.

The old stable distribution (woody) does not contain mydns packages.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.0-4sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 1.1.0+pre-3.

We recommend that you upgrade your mydns package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20963-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 963-1 (mydns)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mydns-common", ver:"1.0.0-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mydns-mysql", ver:"1.0.0-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mydns-pgsql", ver:"1.0.0-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
