# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12606 (httpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66557);
 script_cve_id("CVE-2009-3555", "CVE-2009-3094", "CVE-2009-3095");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 12 FEDORA-2009-12606 (httpd)");

 desc = "The remote host is missing an update to Apache HTTP Server
announced via advisory FEDORA-2009-12606.

For details, please visit the referenced advisories.

ChangeLog:

* Thu Dec  3 2009 Joe Orton  - 2.2.14-1
- update to 2.2.14
- relax permissions on /var/run/httpd (#495780)
- Requires(pre): httpd in mod_ssl subpackage (#543275)
- add partial security fix for CVE-2009-3555 (#533125)

References:

[ 1 ] Bug #521619 - CVE-2009-3094 httpd: NULL pointer defer in mod_proxy_ftp caused by crafted EPSV and PASV reply
https://bugzilla.redhat.com/show_bug.cgi?id=521619
[ 2 ] Bug #522209 - CVE-2009-3095 httpd: mod_proxy_ftp FTP command injection via Authorization HTTP header
https://bugzilla.redhat.com/show_bug.cgi?id=522209

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update httpd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12606

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-12606 (httpd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-tools", rpm:"httpd-tools~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.14~1.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
