#
#VID 97edf5ab-b319-11d9-837d-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52128);
 script_cve_id("CVE-2005-1108", "CVE-2005-1109");
 script_bugtraq_id(13146,13147);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: junkbuster";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   junkbuster
   junkbuster-zlib

CVE-2005-1108
The ij_untrusted_url function in JunkBuster 2.0.2-r2, with
single-threaded mode enabled, allows remote attackers to overwrite the
referrer field via a crafted HTTP request.

CVE-2005-1109
The filtering of URLs in JunkBuster before 2.0.2-r3 allows remote
attackers to cause a denial of service (application crash) and
possibly execute arbitrary code via heap corruption.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2005/dsa-713
http://www.gentoo.org/security/en/glsa/glsa-200504-11.xml
http://www.vuxml.org/freebsd/97edf5ab-b319-11d9-837d-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: junkbuster";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"junkbuster");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.2_3")<0) {
    security_note(0, data:"Package junkbuster version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"junkbuster-zlib");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package junkbuster-zlib version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
