#
#VID 04c6187d-2d8f-11dd-98c9-00163e000016
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61120);
 script_cve_id("CVE-2007-0071");
 script_bugtraq_id(29386);
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: linux-flashplugin";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: linux-flashplugin

CVE-2007-0071
Integer overflow in Adobe Flash Player 9.0.115.0 and earlier, and
8.0.39.0 and earlier, allows remote attackers to execute arbitrary
code via a crafted SWF file with a negative Scene Count value, which
passes a signed comparison, is used as an offset of a NULL pointer,
and triggers a buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://blogs.adobe.com/psirt/
http://www.vuxml.org/freebsd/04c6187d-2d8f-11dd-98c9-00163e000016.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: linux-flashplugin";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"9.0r124")<0) {
    security_note(0, data:"Package linux-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
