###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for AAA Server HPSBUX01011
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835158);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "HPSBUX", value: "01011");
  script_cve_id("CAN-2004-0079", "CAN-2004-0112", "CAN-2004-0081");
  script_name( "HP-UX Update for AAA Server HPSBUX01011");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified withthe HP-UX AAA 
  server where an unauthenticated remote attackercould cause a Denial of 
  Service (DoS). 

  Impact:
  Remote denial of service.

  Affected Software/OS:
  AAA Server on
  HP-UX B.11.00 and B.11.11 running HP-UX AAA Server A.06.01.02.04 HP-UX 
  B.11.23 running HP-UX AAA Server A.06.01.02.06. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00897351-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of AAA Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"AAAServer", revision:"A.06.01.02.07", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"AAAServer", revision:"A.06.01.02.07", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"AAAServer", revision:"A.06.01.02.07", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
