###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdegraphics MDVA-2008:079 (kdegraphics)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830357);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:079");
  script_name( "Mandriva Update for kdegraphics MDVA-2008:079 (kdegraphics)");
  desc = "

  Vulnerability Insight:

  Display session in Kdesktop preference window would hang the X server.
  
  This update fixes this bug.

  Affected Software/OS:
  kdegraphics on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00040.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdegraphics");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"kdegraphics", rpm:"kdegraphics~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-common", rpm:"kdegraphics-common~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kcolorchooser", rpm:"kdegraphics-kcolorchooser~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kcoloredit", rpm:"kdegraphics-kcoloredit~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kdvi", rpm:"kdegraphics-kdvi~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kfax", rpm:"kdegraphics-kfax~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kghostview", rpm:"kdegraphics-kghostview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kiconedit", rpm:"kdegraphics-kiconedit~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kolourpaint", rpm:"kdegraphics-kolourpaint~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kooka", rpm:"kdegraphics-kooka~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kpdf", rpm:"kdegraphics-kpdf~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kpovmodeler", rpm:"kdegraphics-kpovmodeler~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kruler", rpm:"kdegraphics-kruler~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-ksnapshot", rpm:"kdegraphics-ksnapshot~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-ksvg", rpm:"kdegraphics-ksvg~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kuickshow", rpm:"kdegraphics-kuickshow~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-kview", rpm:"kdegraphics-kview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics-mrmlsearch", rpm:"kdegraphics-mrmlsearch~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-common", rpm:"libkdegraphics0-common~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-common-devel", rpm:"libkdegraphics0-common-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kghostview", rpm:"libkdegraphics0-kghostview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kghostview-devel", rpm:"libkdegraphics0-kghostview-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kooka", rpm:"libkdegraphics0-kooka~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kooka-devel", rpm:"libkdegraphics0-kooka-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kpovmodeler", rpm:"libkdegraphics0-kpovmodeler~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kpovmodeler-devel", rpm:"libkdegraphics0-kpovmodeler-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-ksvg", rpm:"libkdegraphics0-ksvg~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-ksvg-devel", rpm:"libkdegraphics0-ksvg-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kview", rpm:"libkdegraphics0-kview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdegraphics0-kview-devel", rpm:"libkdegraphics0-kview-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-common", rpm:"lib64kdegraphics0-common~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-common-devel", rpm:"lib64kdegraphics0-common-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kghostview", rpm:"lib64kdegraphics0-kghostview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kghostview-devel", rpm:"lib64kdegraphics0-kghostview-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kooka", rpm:"lib64kdegraphics0-kooka~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kooka-devel", rpm:"lib64kdegraphics0-kooka-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kpovmodeler", rpm:"lib64kdegraphics0-kpovmodeler~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kpovmodeler-devel", rpm:"lib64kdegraphics0-kpovmodeler-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-ksvg", rpm:"lib64kdegraphics0-ksvg~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-ksvg-devel", rpm:"lib64kdegraphics0-ksvg-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kview", rpm:"lib64kdegraphics0-kview~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdegraphics0-kview-devel", rpm:"lib64kdegraphics0-kview-devel~3.5.9~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}