###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpbazar_detect.nasl 6093 2010-02-17 16:25:36Z feb $
#
# phpBazar version detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800464);
  script_version("Revision$: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("phpBazar version detection");
  desc = "
  Overview: This script finds the running phpBazar version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of phpBazar in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

pbPort = get_http_port(default:80);
if(!pbPort){
  exit(0);
}

foreach path (make_list("/", "/phpBazar", "/PHPBazar", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:pbPort);
  rcvRes = http_send_recv(port:pbPort, data:sndReq);

  if("Welcome to phpBazar!" >< rcvRes)
  {
    sndReq = http_get(item:string(path, "/admin/admin.php"), port:pbPort);
    rcvRes = http_send_recv(port:pbPort, data:sndReq);

    if("phpBazar-AdminPanel" >< rcvRes)
    {
      pbVer = eregmatch(pattern:"phpBazar Ver. ([0-9.]+)", string:rcvRes);
      if(pbVer[1] != NULL){
        pbVer= pbVer[1];
      }
    }
    else
    {
      sndReq = http_get(item:string(path, "/classified.php"), port:pbPort);
      rcvRes = http_send_recv(port:pbPort, data:sndReq);

      if(!isnull(rcvRes))
      {
        pbVer = eregmatch(pattern:"phpBazar Ver. ([0-9.]+)", string:rcvRes);
        if(pbVer[1] != NULL){
          pbVer= pbVer[1];
        }
      }
    }

    set_kb_item(name:"www/" + pbPort + "/phpBazar",
                value:pbVer + " under " + path);
    security_note(data:"phpBazar version " + pbVer + " running at location " 
                    + path + " was detected on the host");
  }
}
