###############################################################################
# OpenVAS Vulnerability Test
# $Id: ntop_36074.nasl 8287 2010-07-05 10:40:56Z mime $
#
# ntop HTTP Basic Authentication NULL Pointer Dereference Denial Of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100255);
 script_bugtraq_id(36074);
 script_cve_id("CVE-2009-2732");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("ntop HTTP Basic Authentication NULL Pointer Dereference Denial Of Service Vulnerability");

desc = "

Overview:
The 'ntop' tool is prone to a denial-of-service vulnerability because
of a NULL-pointer dereference that occurs when crafted HTTP Basic
Authentication credentials are received by the embedded webserver.

An attacker can exploit this issue to crash the affected application,
denying service to legitimate users.

This issue affects ntop 3.3.10; other versions may also be affected.

References:
http://www.securityfocus.com/bid/36074
http://www.ntop.org/ntop.html
http://www.securityfocus.com/archive/1/505876
http://www.securityfocus.com/archive/1/505862


Risk factor : Low";

 script_description(desc);
 script_summary("Determine if ntop is prone to a denial-of-service vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("ntop_detect.nasl");
 script_require_keys("/ntop/installed");
 script_require_ports("Services/www", 3000);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("global_settings.inc");
include("version_func.inc");
   
port = get_http_port(default:3000);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item("www/" + port + "/ntop" ))exit(0);

if(version_is_equal(version: version, test_version: "3.3.10")) {
  security_warning(port:port);
  exit(0);
}

exit(0);

