###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_apr-utils_xml_dos_vuln.nasl 2745 2009-06-23 17:14:22Z jun $
#
# Apache APR-Utils XML Parser Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900573);
  script_version("$ Revision:1.1 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1955");
  script_bugtraq_id(35253);
  script_name("Apache APR-Utils XML Parser Denial of Service Vulnerability");
  desc = "

  Overview: The host is installed with Apache APR-Utils and is prone to
  Denial of Service Vulnerability.

  Vulnerability Insight:
  An error in the 'expat XML' parser when processing crafted XML documents
  containing a large number of nested entity references.

  Impact:
  Attackers can exploit these issues to crash the application
  resulting into a denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Apache APR-Utils version prior to 1.3.7 on Linux.

  Fix:
  Apply the patch or upgrade to Apache APR-Utils 1.3.7
  http://apr.apache.org/download.cgi

  References:
  http://www.apache.org/dist/apr/CHANGES-APR-UTIL-1.3
  http://svn.apache.org/viewvc?view=rev&revision=781403

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apache APR-Utils");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_apache_apr-utils_detect.nasl");
  script_require_keys("Apache/APR-Utils/Ver");
  exit(0);
}


include("version_func.inc");

utilsVer = get_kb_item("Apache/APR-Utils/Ver");
if(!utilsVer){
  exit(0);
}

if(version_is_less(version:utilsVer, test_version:"1.3.7")){
  security_warning(0);
}
