###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_easy_rmtomp3_conv_detect.nasl 1825 2009-04-28 20:07:05Z apr $
#
# Easy RmtoMp3 Converter Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900632);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Easy RmtoMp3 Converter Version Detection");
  desc = "

  Overview: The script detects the installed Easy RmtoMp3 Converter application
  and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of Easy RmtoMp3 Converter");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
      exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  rmtomp3Name = registry_get_sz(item:"DisplayName", key:key + item);
  if(rmtomp3Name =~ "Easy RM to MP3 Converter")
  {
    rmtomp3Ver = eregmatch(pattern:" ([0-9.]+)",string:rmtomp3Name);
    if(rmtomp3Ver[1] != NULL){
      set_kb_item(name:"EasyRmtoMp3/Conv/Ver", value:rmtomp3Ver[1]);
      security_note(data:"Easy RmtoMp3 Converter version " + rmtomp3Ver[1] +
                                                " was detected on the host");
    }
  }
}
