###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_excel_remote_code_exec_vuln.nasl 633 2009-03-17 18:20:09Z mar $
#
# Microsoft Excel Remote Code Execution Vulnerabilities (968557)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Update description and file check to reflect MS09-009 Bulletin.
#  - By Chandan S, 2009-04-15 14:47:49
#
# Make use of version_func_inc - By Chandan S, 11:48:13 2009/04/24
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900476);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0238", "CVE-2009-0100");
  script_bugtraq_id(33870, 34413);
  script_name("Microsoft Excel Remote Code Execution Vulnerabilities (968557)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-009.

  Vulnerability Insight:
  Flaws are due to Memory corruption error and an invalid object access when
  processing a malformed Excel document, which in cause a application crash.

  Impact:
  Successful exploitation could allow execution of arbitrary code by tricking
  a user into opening a specially crafted Excel file.

  Impact Level: System

  Affected Software/OS:
  Microsoft Office Excel 2K  SP3
  Microsoft Office Excel 2k2 SP3
  Microsoft Office Excel 2k3 SP3
  Microsoft Office Excel 2k7 SP1

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-009.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-009.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the MS Office Excel file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_office_products_version_900032.nasl",
                      "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion", "SMB/Office/Excel/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(egrep(pattern:"^(9|10|11|12)\..*", string:get_kb_item("MS/Office/Ver")))
{
  excelVer = get_kb_item("SMB/Office/Excel/Version");
  if(!excelVer){
    exit(0);
  }

  if(version_in_range(version:excelVer, test_version:"9.0",
                      test_version2:"9.0.0.8976")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"10.0",
                           test_version2:"10.0.6851")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"11.0",
                           test_version2:"11.0.8301")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"12.0",
                           test_version2:"12.0.6341.5000")){
    security_hole(0);
  }
}
