###################################################################################
#
#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
# This script is released under the GNU GPLv2
#
# kst-depend-misc
#################################################################################

if(description)
{
  script_id(80017);
  script_version("$Revision: 1.4 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
  script_bugtraq_id(80017);
  script_cve_id("CVE-2007-1560");
  desc = "
  Synopsis :
  A vulnerability in TRACE request processing has been reported in Squid,
  which can be exploited by malicious people to cause a denial of service.

  See also:
  http://www.squid-cache.org/Advisories/SQUID-2007_1.txt
  Solution: 
  Upgrade to squid 2.6 or newer.

  Risk factor:Medium";
  script_description(desc);
  script_name("Squid < 2.6.STABLE12");
  script_summary("Determines squid version");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2007 David Maciejak");
  script_family("Denial of Service");
  script_dependencies("secpod_squid_detect.nasl");
  exit(0);
}


include("version_func.inc");
port = get_kb_item("Services/http_proxy");
if(!port){
  port = 3128;
}

if(!get_port_state(port)){
  port = 8080;
}


squidVer =get_kb_item(string("www/", port, "/Squid"));
if(!squidVer){
  exit(0);
}
# checking for the Version < =2.6
if(egrep(pattern:"2\.([0-5]\.|6\.STABLE([0-9][^0-9]|1[01][^0-9]))", string:squidVer))
{
  security_warning(port);
  exit(0);
}
