#!/location/of/perl
#
# For people that want to transfer their Synchronize calendar schedule to the
# PalmPilot.  Here is a working perl version.  It's very simple, but it works.
# Dwayne Forsyth, forsyth@cig.mot.com, 19980603
#
# sync-pilot.pl [-u <sync user name>]
#               [-d <# days forward to do>]
#               [-p <port to palm>]
#               [-s <sync server>]
#
use PDA::Pilot;
use Data::Dumper;

my(%app_store);
my($DBNAME) = "DatebookDB";

sub store_apt_line {
  my ($rec) = @_;

  $date_key = sprintf "%2.2d/%2.2d/%2.2d %2.2d:%2.2d %d",
         $rec->{'begin'}[5],
         $rec->{'begin'}[4],
         $rec->{'begin'}[3],
         $rec->{'begin'}[2],
         $rec->{'begin'}[1],
         $rec->{'id'};
  $app_store{"$date_key"} = $rec;
}

sub print_apt_line {
  my ($rec) = @_;

  my @month = (qw(Jan Feb Mar Apr May Jue Jul Aus Sep Oct Nov Dec));

  printf "%3s %2.2d/%2.2d %2.2d:%2.2d - %2.2d:%2.2d %s\n",
         $month[$rec->{'begin'}[4]],
         $rec->{'begin'}[3],
         $rec->{'begin'}[5]+1900,
         $rec->{'begin'}[2],
         $rec->{'begin'}[1],
         $rec->{'end'}[2],
         $rec->{'end'}[1],
         $rec->{'description'};
}


sub load_pilot_date_book {
   my($dlp) = @_;
 
   my($r,$i,$db);

   print ">>Getting data out of pilot<<\n";
 
   $db  = $dlp->open($DBNAME);

   $i = 0;
   while ($r = $db->getRecord($i++)) {
      if (!($r->{description} =~ /\(s\)/)) {
      &store_apt_line($r);
      } else {
#         print "Skip \"",$r->{description},"\"\n";
      }
   }
   $db->close();

   undef $db; # Close database
}

sub load_sync {
   my($server,$user,$days) = @_;

   my(@sync);

   if (defined $server) { $server = "-server ".$server; }

   print ">>Getting data out of Sync... Please Wait<<\n";
   open(SYNC, "synchronize $server -day -user $user -range $days|");

   @sync = <SYNC>;
   close (SYNC);

   return(@sync)
}

sub parse_sync {
   my($db, @data_in) = @_;
   my($year,$month,$day,$a);

   print ">>Parsing Sync data<<\n";

   foreach $a (@data_in) {
      if ($a =~ /#For \w+ \d+, (\d+)/) {
         $year = $1;
      } else {
         if ($a =~ /(\d+)\/(\d+)/) { $month = $1, $day = $2; }
         if ($a =~ /(\d\d):(\d\d)([ap])m-(\d\d):(\d\d)([ap])m\t(.*)/) {
            $rec = $db->newRecord();
            $rec->{'begin'}[0] = 0;
            $rec->{'begin'}[1] = $2;
            $rec->{'begin'}[2] = $1;
            if ($3 eq "p") { $rec->{'begin'}[2] += 12; }
            $rec->{'begin'}[3] = $day;
            $rec->{'begin'}[4] = $month -1;
            $rec->{'begin'}[5] = $year - 1900;
            $rec->{'end'}[0] = 0;
            $rec->{'end'}[1] = $5;
            $rec->{'end'}[2] = $4;
            if ($6 eq "p") { $rec->{'end'}[2] += 12; }
            $rec->{'end'}[3] = $day;
            $rec->{'end'}[4] = $month - 1;
            $rec->{'end'}[5] = $year - 1900;
            $rec->{'description'} = $7." (s)";
            $rec->{'secret'} = 0;
            $rec->{'deleted'} = 0;
            $rec->{'modified'} = 0;
            $rec->{'busy'} = 0;
            $rec->{'archived'} = 0;
            $rec->{'category'} = "Work";
#            print "rec = ",Dumper($rec);
            &store_apt_line($rec);
         }
      }
   }
}

sub dump_appt {
   my($a);

   foreach $a (sort keys %app_store) {
      &print_apt_line($app_store{$a});
   }
}

sub create_pilot_date_book {
   my($dlp) = @_;

   print ">>Create Pilot Datebook<<\n";
   $db  = $dlp->create($DBNAME, 'date', 'DATA', 0, 0);

   return($db);
}

sub store_pilot_date_book {
   my($db) = @_;
   my($a,$i,$rec);


   print ">>Store Pilot Datebook<<\n";
   $i = 0;
   foreach $a (sort keys %app_store) {
      $app_store{$a}->{"id"} = $i++;
      $id = $db->setRecord($app_store{$a});
   }
}


sub delete_pilot_date_book {
   my($dlp) = @_;

   print ">>Erasing Pilot Datebook<<\n";
   $dlp->delete($DBNAME);

}

#
# M A I N
#

require "getopts.pl";

&Getopts("u:s:d:p:");

#
#  number of days to pull from Synchronize
#
if (!defined $opt_d) { $opt_d = 15; }
#
#  User name for Synchronize, if not given try unix id
#
if (!defined $opt_u) {
   if (defined $ENV{USER}) {
      $opt_u = $ENV{USER};
   } else {
      print "Error: Need either -u <synchronize name> or enviroment var \$USER set\n";
   }
}
#
#  Synchronize database name, if not given, we will not pass option.
#
if ((!defined $opt_s)&&(defined $ENV{SYNCHROSERVER})) {
   $opt_s = $ENV{SYNCHROSERVER};
}
#
#  port to talk to palm pilot
#
if (!defined $opt_p) {
   if (defined $ENV{PILOTPORT}) {
      $opt_p = $ENV{PILOTPORT};
   } else {
      print "Error: Need either -p <pilot port> or enviroment var \$PILOTPORT set\n";
      exit(1);
   }
}

#
#  @data is a kludge to work around a slow Synchronize server. I get the info
#  from Synchronize before I start talking to palm pilot to avoid communication
#  timeouts. Can't parse the sync data sooner because I nned the database
#  object PDA::Pilot::DLP::DBPtr::create.
#

@data = &load_sync($opt_s,$opt_u,$opt_d);

print "Now press the HotSync button\n";

$socket = PDA::Pilot::openPort($opt_p);
$dlp = PDA::Pilot::accept($socket);

&load_pilot_date_book($dlp);

&delete_pilot_date_book($dlp);

$db = &create_pilot_date_book($dlp);

&parse_sync($db,@data);

&store_pilot_date_book($db);

undef $dlp; # Close connection
