/*
 *      account_checker.hpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#ifndef ACCOUNT_CHECKER_HPP
#define ACCOUNT_CHECKER_HPP

#include <QBasicTimer>
#include <QTimerEvent>
#include <qstring.h>
#include <KConfig>
#include <KConfigGroup>
#include <kstandarddirs.h>
#include <string>
#include "pop.hpp"
#include "imap.hpp"

class account_checker : public QObject {
    Q_OBJECT
    public:
    account_checker (KConfig*);
	virtual ~account_checker ();

	void start();

	protected:
	void timerEvent(QTimerEvent *event);

    private:
	void check();
	void update_config();

    KConfig *conf;
    KConfigGroup conf_gr;
    int mails;
    base_io *mail;
    std::string user, pw, server;
	std::string header;
    int type, sleep_time;
	bool ssl, headers;
	QBasicTimer sleep_timer;

    signals:
    void signal_mails (int, std::string = "");
};

#endif
