# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class X12ProtocolSettings(Model):
    """The X12 agreement protocol settings.

    :param validation_settings: The X12 validation settings.
    :type validation_settings: :class:`X12ValidationSettings
     <azure.mgmt.logic.models.X12ValidationSettings>`
    :param framing_settings: The X12 framing settings.
    :type framing_settings: :class:`X12FramingSettings
     <azure.mgmt.logic.models.X12FramingSettings>`
    :param envelope_settings: The X12 envelope settings.
    :type envelope_settings: :class:`X12EnvelopeSettings
     <azure.mgmt.logic.models.X12EnvelopeSettings>`
    :param acknowledgement_settings: The X12 acknowledgment settings.
    :type acknowledgement_settings: :class:`X12AcknowledgementSettings
     <azure.mgmt.logic.models.X12AcknowledgementSettings>`
    :param message_filter: The X12 message filter.
    :type message_filter: :class:`X12MessageFilter
     <azure.mgmt.logic.models.X12MessageFilter>`
    :param security_settings: The X12 security settings.
    :type security_settings: :class:`X12SecuritySettings
     <azure.mgmt.logic.models.X12SecuritySettings>`
    :param processing_settings: The X12 processing settings.
    :type processing_settings: :class:`X12ProcessingSettings
     <azure.mgmt.logic.models.X12ProcessingSettings>`
    :param envelope_overrides: The X12 envelope override settings.
    :type envelope_overrides: list of :class:`X12EnvelopeOverride
     <azure.mgmt.logic.models.X12EnvelopeOverride>`
    :param validation_overrides: The X12 validation override settings.
    :type validation_overrides: list of :class:`X12ValidationOverride
     <azure.mgmt.logic.models.X12ValidationOverride>`
    :param message_filter_list: The X12 message filter list.
    :type message_filter_list: list of :class:`X12MessageIdentifier
     <azure.mgmt.logic.models.X12MessageIdentifier>`
    :param schema_references: The X12 schema references.
    :type schema_references: list of :class:`X12SchemaReference
     <azure.mgmt.logic.models.X12SchemaReference>`
    :param x12_delimiter_overrides: The X12 delimiter override settings.
    :type x12_delimiter_overrides: list of :class:`X12DelimiterOverrides
     <azure.mgmt.logic.models.X12DelimiterOverrides>`
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'security_settings': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'X12ValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'X12FramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'X12EnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'X12AcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'X12MessageFilter'},
        'security_settings': {'key': 'securitySettings', 'type': 'X12SecuritySettings'},
        'processing_settings': {'key': 'processingSettings', 'type': 'X12ProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[X12EnvelopeOverride]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[X12ValidationOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[X12MessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[X12SchemaReference]'},
        'x12_delimiter_overrides': {'key': 'x12DelimiterOverrides', 'type': '[X12DelimiterOverrides]'},
    }

    def __init__(self, validation_settings, framing_settings, envelope_settings, acknowledgement_settings, message_filter, security_settings, processing_settings, schema_references, envelope_overrides=None, validation_overrides=None, message_filter_list=None, x12_delimiter_overrides=None):
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.security_settings = security_settings
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.validation_overrides = validation_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.x12_delimiter_overrides = x12_delimiter_overrides
