# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class BackupVaultConfig(Resource):
    """Backup vault config details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant'
    :type storage_type: str or :class:`StorageType
     <azure.mgmt.recoveryservices.models.StorageType>`
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or :class:`StorageTypeState
     <azure.mgmt.recoveryservices.models.StorageTypeState>`
    :param enhanced_security_state: Enabled or Disabled. Possible values
     include: 'Invalid', 'Enabled', 'Disabled'
    :type enhanced_security_state: str or :class:`EnhancedSecurityState
     <azure.mgmt.recoveryservices.models.EnhancedSecurityState>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'storage_type_state': {'key': 'properties.storageTypeState', 'type': 'str'},
        'enhanced_security_state': {'key': 'properties.enhancedSecurityState', 'type': 'str'},
    }

    def __init__(self, e_tag=None, storage_type=None, storage_type_state=None, enhanced_security_state=None):
        super(BackupVaultConfig, self).__init__(e_tag=e_tag)
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.enhanced_security_state = enhanced_security_state
