# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from . import models


class ServiceFabricClientAPIsConfiguration(Configuration):
    """Configuration for ServiceFabricClientAPIs
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: :mod:`A msrest Authentication
     object<msrest.authentication>`
    :param str base_url: Service URL
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, base_url=None, filepath=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'http://localhost:19080'

        super(ServiceFabricClientAPIsConfiguration, self).__init__(base_url, filepath)

        self.add_user_agent('servicefabricclientapis/{}'.format(VERSION))

        self.credentials = credentials


class ServiceFabricClientAPIs(object):
    """Service Fabric REST Client APIs allows management of Service Fabric clusters, applications and services.

    :ivar config: Configuration for client.
    :vartype config: ServiceFabricClientAPIsConfiguration

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: :mod:`A msrest Authentication
     object<msrest.authentication>`
    :param str base_url: Service URL
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, base_url=None, filepath=None):

        self.config = ServiceFabricClientAPIsConfiguration(credentials, base_url, filepath)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_cluster_manifest(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Get the Service Fabric cluster manifest.

        Get the Service Fabric cluster manifest. The cluster manifest contains
        properties of the cluster that include different node types on the
        cluster,
        security configurations, fault and upgrade domain topologies etc.
        These properties are specified as part of the ClusterConfig.JSON file
        while deploying a stand alone cluster. However, most of the
        information in the cluster manifest
        is generated internally by service fabric during cluster deployment in
        other deployment scenarios (for e.g when using azuer portal).
        The contents of the cluster manifest are for informational purposes
        only and users are not expected to take a dependency on the format of
        the file contents or its interpretation.
        .

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterManifest
         <azure.servicefabric.models.ClusterManifest>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetClusterManifest'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterManifest', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_cluster_health(
            self, nodes_health_state_filter=0, applications_health_state_filter=0, events_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric cluster.

        Gets the health of a Service Fabric cluster.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the cluster based on the health state.
        Similarly, use NodesHealthStateFilter and
        ApplicationsHealthStateFilter to filter the collection of nodes and
        applications returned based on their aggregated health state.
        .

        :param nodes_health_state_filter: Allows filtering of the node health
         state objects returned in the result of cluster health query
         based on their health state. The possible values for this parameter
         include integer value of one of the
         following health states. Only nodes that match the filter are
         returned. All nodes are used to evaluate the aggregated health state.
         If not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these values obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of nodes
         with HealthState value of OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type nodes_health_state_filter: int
        :param applications_health_state_filter: Allows filtering of the
         application health state objects returned in the result of cluster
         health
         query based on their health state.
         The possible values for this parameter include integer value obtained
         from members or bitwise operations
         on members of HealthStateFilter enumeration. Only applications that
         match the filter are returned.
         All applications are used to evaluate the aggregated health state. If
         not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these values obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of
         applications with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type applications_health_state_filter: int
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterHealth
         <azure.servicefabric.models.ClusterHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetClusterHealth'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if nodes_health_state_filter is not None:
            query_parameters['NodesHealthStateFilter'] = self._serialize.query("nodes_health_state_filter", nodes_health_state_filter, 'int')
        if applications_health_state_filter is not None:
            query_parameters['ApplicationsHealthStateFilter'] = self._serialize.query("applications_health_state_filter", applications_health_state_filter, 'int')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_cluster_health_using_policy(
            self, nodes_health_state_filter=0, applications_health_state_filter=0, events_health_state_filter=0, timeout=60, application_health_policy_map=None, cluster_health_policy=None, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric cluster using the specified
        policy.

        Gets the health of a Service Fabric cluster.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the cluster based on the health state.
        Similarly, use NodesHealthStateFilter and
        ApplicationsHealthStateFilter to filter the collection of nodes and
        applications returned based on their aggregated health state.
        Use ClusterHealthPolicies to override the health policies used to
        evaluate the health.
        .

        :param nodes_health_state_filter: Allows filtering of the node health
         state objects returned in the result of cluster health query
         based on their health state. The possible values for this parameter
         include integer value of one of the
         following health states. Only nodes that match the filter are
         returned. All nodes are used to evaluate the aggregated health state.
         If not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these values obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of nodes
         with HealthState value of OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type nodes_health_state_filter: int
        :param applications_health_state_filter: Allows filtering of the
         application health state objects returned in the result of cluster
         health
         query based on their health state.
         The possible values for this parameter include integer value obtained
         from members or bitwise operations
         on members of HealthStateFilter enumeration. Only applications that
         match the filter are returned.
         All applications are used to evaluate the aggregated health state. If
         not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these values obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of
         applications with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type applications_health_state_filter: int
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param application_health_policy_map:
        :type application_health_policy_map: list of
         :class:`ApplicationHealthPolicyMapItem
         <azure.servicefabric.models.ApplicationHealthPolicyMapItem>`
        :param cluster_health_policy:
        :type cluster_health_policy: :class:`ClusterHealthPolicy
         <azure.servicefabric.models.ClusterHealthPolicy>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterHealth
         <azure.servicefabric.models.ClusterHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        cluster_health_policies = None
        if application_health_policy_map is not None or cluster_health_policy is not None:
            cluster_health_policies = models.ClusterHealthPolicies(application_health_policy_map=application_health_policy_map, cluster_health_policy=cluster_health_policy)

        api_version = "3.0"

        # Construct URL
        url = '/$/GetClusterHealth'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if nodes_health_state_filter is not None:
            query_parameters['NodesHealthStateFilter'] = self._serialize.query("nodes_health_state_filter", nodes_health_state_filter, 'int')
        if applications_health_state_filter is not None:
            query_parameters['ApplicationsHealthStateFilter'] = self._serialize.query("applications_health_state_filter", applications_health_state_filter, 'int')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if cluster_health_policies is not None:
            body_content = self._serialize.body(cluster_health_policies, 'ClusterHealthPolicies')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_cluster_health_chunk(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric cluster using health chunks.

        Gets the health of a Service Fabric cluster using health chunks.
        Includes the aggregated health state of the cluster, but none of the
        cluster entities.
        To expand the cluster health and get the health state of all or some
        of the entities, use the POST URI and specify the cluster health
        chunk query description.
        .

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterHealthChunk
         <azure.servicefabric.models.ClusterHealthChunk>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetClusterHealthChunk'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterHealthChunk', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_cluster_health_chunk_using_policy_and_advanced_filters(
            self, cluster_health_chunk_query_description=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric cluster using health chunks.

        Gets the health of a Service Fabric cluster using health chunks. The
        health evaluation is done based on the input cluster health chunk
        query description.
        The query description allows users to specify health policies for
        evaluating the cluster and its children.
        Users can specify very flexible filters to select which cluster
        entities to return. The selection can be done based on the entities
        health state and based on the hierarchy.
        The query can return multi-level children of the entities based on the
        specified filters. For example, it can return one application with a
        specified name, and for this application, return
        only services that are in Error or Warning, and all partitions and
        replicas for one of these services.
        .

        :param cluster_health_chunk_query_description: Describes the cluster
         and application health policies used to evaluate the cluster health
         and the filters to select which cluster entities to be returned.
         If the cluster health policy is present, it is used to evaluate the
         cluster events and the cluster nodes. If not present, the health
         evaluation uses the cluster health policy defined in the cluster
         manifest or the default cluster health policy.
         By default, each application is evaluated using its specific
         application health policy, defined in the application manifest, or
         the default health policy, if no policy is defined in manifest.
         If the application health policy map is specified, and it has an
         entry for an application, the specified application health policy
         is used to evaluate the application health.
         Users can specify very flexible filters to select which cluster
         entities to include in response. The selection can be done based on
         the entities health state and based on the hierarchy.
         The query can return multi-level children of the entities based on
         the specified filters. For example, it can return one application
         with a specified name, and for this application, return
         only services that are in Error or Warning, and all partitions and
         replicas for one of these services.
        :type cluster_health_chunk_query_description:
         :class:`ClusterHealthChunkQueryDescription
         <azure.servicefabric.models.ClusterHealthChunkQueryDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterHealthChunk
         <azure.servicefabric.models.ClusterHealthChunk>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetClusterHealthChunk'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if cluster_health_chunk_query_description is not None:
            body_content = self._serialize.body(cluster_health_chunk_query_description, 'ClusterHealthChunkQueryDescription')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterHealthChunk', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_cluster_health(
            self, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric cluster.

        Sends a health report on a Service Fabric cluster. The report must
        contain the information about the source of the health report and
        property on which it is reported.
        The report is sent to a Service Fabric gateway node, which forwards to
        the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetClusterHealth and check that the report appears in the
        HealthEvents section.
        .

        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/ReportClusterHealth'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_provisioned_fabric_code_version_info_list(
            self, code_version=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets a list of fabric code versions that are provisioned in a Service
        Fabric cluster.

        Gets a list of information about fabric code versions that are
        provisioned in the cluster. The parameter CodeVersion can be used to
        optionally filter the output to only that particular version.

        :param code_version: The product version of Service Fabric.
        :type code_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`FabricCodeVersionInfo
         <azure.servicefabric.models.FabricCodeVersionInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetProvisionedCodeVersions'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if code_version is not None:
            query_parameters['CodeVersion'] = self._serialize.query("code_version", code_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[FabricCodeVersionInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_provisioned_fabric_config_version_info_list(
            self, config_version=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets a list of fabric config versions that are provisioned in a
        Service Fabric cluster.

        Gets a list of information about fabric config versions that are
        provisioned in the cluster. The parameter ConfigVersion can be used
        to optionally filter the output to only that particular version.

        :param config_version: The config version of Service Fabric.
        :type config_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`FabricConfigVersionInfo
         <azure.servicefabric.models.FabricConfigVersionInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetProvisionedConfigVersions'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if config_version is not None:
            query_parameters['ConfigVersion'] = self._serialize.query("config_version", config_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[FabricConfigVersionInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_cluster_upgrade_progress(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the progress of the current cluster upgrade.

        Gets the current progress of the ongoing cluster upgrade. If no
        upgrade is currently in progress, gets the last state of the previous
        cluster upgrade.

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ClusterUpgradeProgressObject
         <azure.servicefabric.models.ClusterUpgradeProgressObject>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/GetUpgradeProgress'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ClusterUpgradeProgressObject', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_aad_metadata(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the Azure Active Directory metadata used for secured connection
        to cluster.

        Gets the Azure Active Directory metadata used for secured connection
        to cluster.
        This API is not supposed to be called separately. It provides
        information needed to set up an Azure Active Directory secured
        connection with a Service Fabric cluster.
        .

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AadMetadataObject
         <azure.servicefabric.models.AadMetadataObject>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "1.0"

        # Construct URL
        url = '/$/GetAadMetadata'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AadMetadataObject', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_node_info_list(
            self, continuation_token=None, node_status_filter="default", timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of nodes in the Service Fabric cluster.

        The Nodes endpoint returns information about the nodes in the Service
        Fabric Cluster. The respons include the name, status, id, health,
        uptime and other details about the node.

        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param node_status_filter: Allows filtering the nodes based on the
         NodeStatus. Only the nodes that are matching the specified filter
         value will be returned. The filter value can be one of the following.
         - default - This filter value will match all of the nodes excepts
         the ones with with status as Unknown or Removed.
         - all - This filter value will match all of the nodes.
         - up - This filter value will match nodes that are Up.
         - down - This filter value will match nodes that are Down.
         - enabling - This filter value will match nodes that are in the
         process of being enabled with status as Enabling.
         - disabling - This filter value will match nodes that are in the
         process of being disabled with status as Disabling.
         - disabled - This filter value will match nodes that are Disabled.
         - unknown - This filter value will match nodes whose status is
         Unknown. A node would be in Unknown state if Service Fabric does not
         have authoritative information about that node. This can happen if
         the system learns about a node at runtime.
         - removed - This filter value will match nodes whose status is
         Removed. These are the nodes that are removed from the cluster using
         the RemoveNodeState API.
         . Possible values include: 'default', 'all', 'up', 'down',
         'enabling', 'disabling', 'disabled', 'unknown', 'removed'
        :type node_status_filter: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedNodeInfoList
         <azure.servicefabric.models.PagedNodeInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if node_status_filter is not None:
            query_parameters['NodeStatusFilter'] = self._serialize.query("node_status_filter", node_status_filter, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedNodeInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_node_info(
            self, node_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of nodes in the Service Fabric cluster.

        Gets the information about a specific node in the Service Fabric
        Cluster.The respons include the name, status, id, health, uptime and
        other details about the node.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`NodeInfo <azure.servicefabric.models.NodeInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_node_health(
            self, node_name, events_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric node.

        Gets the health of a Service Fabric node. Use EventsHealthStateFilter
        to filter the collection of health events reported on the node based
        on the health state. If the node that you specify by name does not
        exist in the health store, this returns an error.

        :param node_name: The name of the node.
        :type node_name: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`NodeHealth <azure.servicefabric.models.NodeHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_node_health_using_policy(
            self, node_name, events_health_state_filter=0, cluster_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric node, by using the specified
        health policy.

        Gets the health of a Service Fabric node. Use EventsHealthStateFilter
        to filter the collection of health events reported on the node based
        on the health state. Use ClusterHealthPolicy in the POST body to
        override the health policies used to evaluate the health. If the node
        that you specify by name does not exist in the health store, this
        returns an error.

        :param node_name: The name of the node.
        :type node_name: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param cluster_health_policy: Describes the health policies used to
         evaluate the health of a cluster or node. If not present, the health
         evaluation uses the health policy from cluster manifest or the
         default health policy.
        :type cluster_health_policy: :class:`ClusterHealthPolicy
         <azure.servicefabric.models.ClusterHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`NodeHealth <azure.servicefabric.models.NodeHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if cluster_health_policy is not None:
            body_content = self._serialize.body(cluster_health_policy, 'ClusterHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_node_health(
            self, node_name, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric node.

        Reports health state of the specified Service Fabric node. The report
        must contain the information about the source of the health report
        and property on which it is reported.
        The report is sent to a Service Fabric gateway node, which forwards to
        the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetNodeHealth and check that the report appears in the HealthEvents
        section.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/ReportHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_node_load_info(
            self, node_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the load information of a Service Fabric node.

        Gets the load information of a Service Fabric node.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`NodeLoadInfo
         <azure.servicefabric.models.NodeLoadInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetLoadInformation'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeLoadInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def disable_node(
            self, node_name, timeout=60, deactivation_intent=None, custom_headers=None, raw=False, **operation_config):
        """Deactivate a Service Fabric cluster node with the specified
        deactivation intent.

        Deactivate a Service Fabric cluster node with the specified
        deactivation intent. Once the deactivation is in progress, the
        deactivation intent can be increased, but not decreased (for example,
        a node which is was deactivated with the Pause intent can be
        deactivated further with Restart, but not the other way around. Nodes
        may be reactivated using the Activate a node operation any time after
        they are deactivated. If the deactivation is not complete this will
        cancel the deactivation. A node which goes down and comes back up
        while deactivated will still need to be reactivated before services
        will be placed on that node.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param deactivation_intent: Describes the intent or reason for
         deactivating the node. The possible values are following.
         - Pause - Indicates that the node should be paused. The value is 1.
         - Restart - Indicates that the intent is for the node to be
         restarted after a short period of time. The value is 2.
         - RemoveData - Indicates the intent is for the node to remove data.
         The value is 3.
         . Possible values include: 'Pause', 'Restart', 'RemoveData'
        :type deactivation_intent: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        deactivation_intent_description = models.DeactivationIntentDescription(deactivation_intent=deactivation_intent)

        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/Deactivate'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(deactivation_intent_description, 'DeactivationIntentDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def enable_node(
            self, node_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Activate a Service Fabric cluster node which is currently deactivated.

        Activates a Service Fabric cluster node which is currently
        deactivated. Once activated, the node will again become a viable
        target for placing new replicas, and any deactivated replicas
        remaining on the node will be reactivated.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/Activate'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def remove_node_state(
            self, node_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Notifies Service Fabric that the persisted state on a node has been
        permanently removed or lost.

        Notifies Service Fabric that the persisted state on a node has been
        permanently removed or lost.  This implies that it is not possible to
        recover the persisted state of that node. This generally happens if a
        hard disk has been wiped clean, or if a hard disk crashes. The node
        has to be down for this operation to be successful. This operation
        lets Service Fabric know that the replicas on that node no longer
        exist, and that Service Fabric should stop waiting for those replicas
        to come back up. Do not run this cmdlet if the state on the node has
        not been removed and the node can comes back up with its state intact.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/RemoveNodeState'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def start_node(
            self, node_name, node_instance_id="0", timeout=60, custom_headers=None, raw=False, **operation_config):
        """Starts a Service Fabric cluster node.

        Starts a Service Fabric cluster node that is already stopped.

        :param node_name: The name of the node.
        :type node_name: str
        :param node_instance_id: The instance id of the node that is stopped.
         If instance id is specified the node is started only if it matches
         with the current instance of the stopped node. A default value of
         "0" would match any instance id. The instance id can be obtained
         using get node query.
        :type node_instance_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        start_node_description = models.StartNodeDescription(node_instance_id=node_instance_id)

        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/Start'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(start_node_description, 'StartNodeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def stop_node(
            self, node_name, node_instance_id="0", timeout=60, custom_headers=None, raw=False, **operation_config):
        """Stops a Service Fabric cluster node.

        Stops a Service Fabric cluster node that is in a started state. The
        node will stay down until start node is called.

        :param node_name: The name of the node.
        :type node_name: str
        :param node_instance_id: The instance id of the target node. If
         instance id is specified the node is stopped only if it matches with
         the current instance of the node. A default value of "0" would match
         any instance id. The instance id can be obtained using get node
         query.
        :type node_instance_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        stop_node_description = models.StopNodeDescription(node_instance_id=node_instance_id)

        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/Stop'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(stop_node_description, 'StopNodeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def restart_node(
            self, node_name, node_instance_id="0", timeout=60, create_fabric_dump="False", custom_headers=None, raw=False, **operation_config):
        """Restarts a Service Fabric cluster node.

        Restarts a Service Fabric cluster node that is already started.

        :param node_name: The name of the node.
        :type node_name: str
        :param node_instance_id: The instance id of the target node. If
         instance id is specified the node is restarted only if it matches
         with the current instance of the node. A default value of "0" would
         match any instance id. The instance id can be obtained using get
         node query.
        :type node_instance_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param create_fabric_dump: Specify True to create a dump of the
         fabric node process. This is case sensitive. Possible values
         include: 'False', 'True'
        :type create_fabric_dump: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        restart_node_description = models.RestartNodeDescription(node_instance_id=node_instance_id, create_fabric_dump=create_fabric_dump)

        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/Restart'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(restart_node_description, 'RestartNodeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_application_type_info_list(
            self, exclude_application_parameters=False, continuation_token=None, max_results=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of application types in the Service Fabric cluster.

        Returns the information about the application types that are
        provisioned or in the process of being provisioned in the Service
        Fabric cluster. Each version of an application type is returned as
        one application type. The response includes the name, version, status
        and other details about the application type. This is a paged query,
        meaning that if not all of the application types fit in a page, one
        page of results is returned as well as a continuation token which can
        be used to get the next page. For example, if there are 10
        application types but a page only fits the first 3 application types,
        or if max results is set to 3, then 3 is returned. To access the rest
        of the results, retrieve subsequent pages by using the returned
        continuation token in the next query. An empty continuation token is
        returned if there are no subsequent pages.

        :param exclude_application_parameters: The flag that specifies
         whether application parameters will be excluded from the result.
        :type exclude_application_parameters: bool
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param max_results: The maximum number of results to be returned as
         part of the paged queries. This parameter defines the upper bound on
         the number of results returned. The results returned can be less
         than the specified maximum results if they do not fit in the message
         as per the max message size restrictions defined in the
         configuration. If this parameter is zero or not specified, the paged
         queries includes as much results as possible that fit in the return
         message.
        :type max_results: long
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedApplicationTypeInfoList
         <azure.servicefabric.models.PagedApplicationTypeInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0"

        # Construct URL
        url = '/ApplicationTypes'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if exclude_application_parameters is not None:
            query_parameters['ExcludeApplicationParameters'] = self._serialize.query("exclude_application_parameters", exclude_application_parameters, 'bool')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if max_results is not None:
            query_parameters['MaxResults'] = self._serialize.query("max_results", max_results, 'long', minimum=0)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedApplicationTypeInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_application_type_info_list_by_name(
            self, application_type_name, exclude_application_parameters=False, continuation_token=None, max_results=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of application types in the Service Fabric cluster
        matching exactly the specified name.

        Returns the information about the application types that are
        provisioned or in the process of being provisioned in the Service
        Fabric cluster. These results are of application types whose name
        match exactly the one specified as the parameter, and which comply
        with the given query parameters. All versions of the application type
        matching the application type name are returned, with each version
        returned as one application type. The response includes the name,
        version, status and other details about the application type. This is
        a paged query, meaning that if not all of the application types fit
        in a page, one page of results is returned as well as a continuation
        token which can be used to get the next page. For example, if there
        are 10 application types but a page only fits the first 3 application
        types, or if max results is set to 3, then 3 is returned. To access
        the rest of the results, retrieve subsequent pages by using the
        returned continuation token in the next query. An empty continuation
        token is returned if there are no subsequent pages.

        :param application_type_name: The name of the application type.
        :type application_type_name: str
        :param exclude_application_parameters: The flag that specifies
         whether application parameters will be excluded from the result.
        :type exclude_application_parameters: bool
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param max_results: The maximum number of results to be returned as
         part of the paged queries. This parameter defines the upper bound on
         the number of results returned. The results returned can be less
         than the specified maximum results if they do not fit in the message
         as per the max message size restrictions defined in the
         configuration. If this parameter is zero or not specified, the paged
         queries includes as much results as possible that fit in the return
         message.
        :type max_results: long
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedApplicationTypeInfoList
         <azure.servicefabric.models.PagedApplicationTypeInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0"

        # Construct URL
        url = '/ApplicationTypes/{applicationTypeName}'
        path_format_arguments = {
            'applicationTypeName': self._serialize.url("application_type_name", application_type_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if exclude_application_parameters is not None:
            query_parameters['ExcludeApplicationParameters'] = self._serialize.query("exclude_application_parameters", exclude_application_parameters, 'bool')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if max_results is not None:
            query_parameters['MaxResults'] = self._serialize.query("max_results", max_results, 'long', minimum=0)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedApplicationTypeInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def provision_application_type(
            self, application_type_build_path, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Provisions or registers a Service Fabric application type with the
        cluster.

        Provisions or registers a Service Fabric application type with the
        cluster. This is required before any new applications can be
        instantiated.

        :param application_type_build_path: The relative image store path to
         the application package.
        :type application_type_build_path: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        application_type_image_store_path = models.ApplicationTypeImageStorePath(application_type_build_path=application_type_build_path)

        api_version = "3.0"

        # Construct URL
        url = '/ApplicationTypes/$/Provision'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(application_type_image_store_path, 'ApplicationTypeImageStorePath')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def unprovision_application_type(
            self, application_type_name, application_type_version, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Removes or unregisters a Service Fabric application type from the
        cluster.

        Removes or unregisters a Service Fabric application type from the
        cluster. This operation can only be performed if all application
        instance of the application type has been deleted. Once the
        application type is unregistered, no new application instance can be
        created for this particular application type.

        :param application_type_name: The name of the application type.
        :type application_type_name: str
        :param application_type_version: The application type version.
        :type application_type_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        application_type_image_store_version = models.ApplicationTypeImageStoreVersion(application_type_version=application_type_version)

        api_version = "3.0"

        # Construct URL
        url = '/ApplicationTypes/{applicationTypeName}/$/Unprovision'
        path_format_arguments = {
            'applicationTypeName': self._serialize.url("application_type_name", application_type_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(application_type_image_store_version, 'ApplicationTypeImageStoreVersion')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_service_type_info_list(
            self, application_type_name, application_type_version, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list containing the information about service types that are
        supported by a provisioned application type in a Service Fabric
        cluster.

        Gets the list containing the information about service types that are
        supported by a provisioned application type in a Service Fabric
        cluster. The response includes the name of the service type, the name
        and version of the service manifest the type is defined in, kind
        (stateless or stateless) of the service type and other information
        about it.

        :param application_type_name: The name of the application type.
        :type application_type_name: str
        :param application_type_version: The version of the application type.
        :type application_type_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`ServiceTypeInfo
         <azure.servicefabric.models.ServiceTypeInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ApplicationTypes/{applicationTypeName}/$/GetServiceTypes'
        path_format_arguments = {
            'applicationTypeName': self._serialize.url("application_type_name", application_type_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['ApplicationTypeVersion'] = self._serialize.query("application_type_version", application_type_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ServiceTypeInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_manifest(
            self, application_type_name, application_type_version, service_manifest_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the manifest describing a service type.

        Gets the manifest describing a service type. The response contains the
        service manifest XML as a string.

        :param application_type_name: The name of the application type.
        :type application_type_name: str
        :param application_type_version: The version of the application type.
        :type application_type_version: str
        :param service_manifest_name: The name of a service manifest
         registered as part of an application type in a Service Fabric
         cluster.
        :type service_manifest_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceTypeManifest
         <azure.servicefabric.models.ServiceTypeManifest>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ApplicationTypes/{applicationTypeName}/$/GetServiceManifest'
        path_format_arguments = {
            'applicationTypeName': self._serialize.url("application_type_name", application_type_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['ApplicationTypeVersion'] = self._serialize.query("application_type_version", application_type_version, 'str')
        query_parameters['ServiceManifestName'] = self._serialize.query("service_manifest_name", service_manifest_name, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceTypeManifest', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_type_info_list(
            self, node_name, application_id, service_manifest_name=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list containing the information about service types from the
        applications deployed on a node in a Service Fabric cluster.

        Gets the list containing the information about service types from the
        applications deployed on a node in a Service Fabric cluster. The
        response includes the name of the service type, its registration
        status, the code package that registered it and activation id of the
        service package.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_manifest_name: The name of the service manifest to
         filter the list of deployed service type information. If specified,
         the response will only contain the information about service types
         that are defined in this service manifest.
        :type service_manifest_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedServiceTypeInfo
         <azure.servicefabric.models.DeployedServiceTypeInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServiceTypes'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if service_manifest_name is not None:
            query_parameters['ServiceManifestName'] = self._serialize.query("service_manifest_name", service_manifest_name, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedServiceTypeInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_type_info_by_name(
            self, node_name, application_id, service_type_name, service_manifest_name=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about a specified service type of the application
        deployed on a node in a Service Fabric cluster.

        Gets the information about a specified service type of the application
        deployed on a node in a Service Fabric cluster. The response includes
        the name of the service type, its registration status, the code
        package that registered it and activation id of the service package.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_type_name: Specifies the name of a Service Fabric
         service type.
        :type service_type_name: str
        :param service_manifest_name: The name of the service manifest to
         filter the list of deployed service type information. If specified,
         the response will only contain the information about service types
         that are defined in this service manifest.
        :type service_manifest_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedServiceTypeInfo
         <azure.servicefabric.models.DeployedServiceTypeInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServiceTypes/{serviceTypeName}'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'serviceTypeName': self._serialize.url("service_type_name", service_type_name, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if service_manifest_name is not None:
            query_parameters['ServiceManifestName'] = self._serialize.query("service_manifest_name", service_manifest_name, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedServiceTypeInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def create_application(
            self, application_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Creates a Service Fabric application.

        Creates a Service Fabric application using the specified description.

        :param application_description: Describes the application to be
         created.
        :type application_description: :class:`ApplicationDescription
         <azure.servicefabric.models.ApplicationDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/$/Create'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(application_description, 'ApplicationDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def delete_application(
            self, application_id, force_remove=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing Service Fabric application.

        Deletes an existing Service Fabric application. An application must be
        created before it can be deleted. Deleting an application will delete
        all services that are part of that application. By default Service
        Fabric will try to close service replicas in a graceful manner and
        then delete the service. However if service is having issues closing
        the replica gracefully, the delete operation may take a long time or
        get stuck. Use the optional ForceRemove flag to skip the graceful
        close sequence and forcefully delete the application and all of the
        its services.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param force_remove: Remove a Service Fabric application or service
         forcefully without going through the graceful shutdown sequence.
         This parameter can be used to forcefully delete an application or
         service for which delete is timing out due to issues in the service
         code that prevents graceful close of replicas.
        :type force_remove: bool
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/Delete'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if force_remove is not None:
            query_parameters['ForceRemove'] = self._serialize.query("force_remove", force_remove, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_application_info_list(
            self, application_type_name=None, exclude_application_parameters=False, continuation_token=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of applications created in the Service Fabric cluster
        that match filters specified as the parameter.

        Gets the information about the applications that were created or in
        the process of being created in the Service Fabric cluster and match
        filters specified as the parameter. The response includes the name,
        type, status, parameters and other details about the application. If
        the applications do not fit in a page, one page of results is
        returned as well as a continuation token which can be used to get the
        next page.

        :param application_type_name: The application type name used to
         filter the applications to query for. This value should not contain
         the application type version.
        :type application_type_name: str
        :param exclude_application_parameters: The flag that specifies
         whether application parameters will be excluded from the result.
        :type exclude_application_parameters: bool
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedApplicationInfoList
         <azure.servicefabric.models.PagedApplicationInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if application_type_name is not None:
            query_parameters['ApplicationTypeName'] = self._serialize.query("application_type_name", application_type_name, 'str')
        if exclude_application_parameters is not None:
            query_parameters['ExcludeApplicationParameters'] = self._serialize.query("exclude_application_parameters", exclude_application_parameters, 'bool')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedApplicationInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_application_info(
            self, application_id, exclude_application_parameters=False, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets information about a Service Fabric application.

        Returns the information about the application that was created or in
        the process of being created in the Service Fabric cluster and whose
        name matches the one specified as the parameter. The response
        includes the name, type, status, parameters and other details about
        the application.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param exclude_application_parameters: The flag that specifies
         whether application parameters will be excluded from the result.
        :type exclude_application_parameters: bool
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationInfo
         <azure.servicefabric.models.ApplicationInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if exclude_application_parameters is not None:
            query_parameters['ExcludeApplicationParameters'] = self._serialize.query("exclude_application_parameters", exclude_application_parameters, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_application_health(
            self, application_id, events_health_state_filter=0, deployed_applications_health_state_filter=0, services_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of the service fabric application.

        Returns the heath state of the service fabric application. The
        response reports either Ok, Error or Warning health state. If the
        entity is not found in the helath store, it will return Error.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param deployed_applications_health_state_filter: Allows filtering of
         the deployed applications health state objects returned in the
         result of application health query based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states. Only deployed applications that
         match the filter will be returned.\\
         All deployed applications are used to evaluate the aggregated health
         state. If not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these value obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of deployed
         applications with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn't match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type deployed_applications_health_state_filter: int
        :param services_health_state_filter: Allows filtering of the services
         health state objects returned in the result of services health query
         based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only services that match the filter are returned. All services are
         used to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these value
         obtained using bitwise 'OR' operator. For example, if the provided
         value is 6 then health state of services with HealthState value of
         OK (2) and Warning (4) will be returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn�t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type services_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationHealth
         <azure.servicefabric.models.ApplicationHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetHealth'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if deployed_applications_health_state_filter is not None:
            query_parameters['DeployedApplicationsHealthStateFilter'] = self._serialize.query("deployed_applications_health_state_filter", deployed_applications_health_state_filter, 'int')
        if services_health_state_filter is not None:
            query_parameters['ServicesHealthStateFilter'] = self._serialize.query("services_health_state_filter", services_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_application_health_using_policy(
            self, application_id, events_health_state_filter=0, deployed_applications_health_state_filter=0, services_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric application using the specified
        policy.

        Gets the health of a Service Fabric application. Use
        EventsHealthStateFilter to filter the collection of health events
        reported on the node based on the health state. Use
        ClusterHealthPolicies to override the health policies used to
        evaluate the health.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param deployed_applications_health_state_filter: Allows filtering of
         the deployed applications health state objects returned in the
         result of application health query based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states. Only deployed applications that
         match the filter will be returned.\\
         All deployed applications are used to evaluate the aggregated health
         state. If not specified, all entries are returned.
         The state values are flag based enumeration, so the value could be a
         combination of these value obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of deployed
         applications with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn't match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type deployed_applications_health_state_filter: int
        :param services_health_state_filter: Allows filtering of the services
         health state objects returned in the result of services health query
         based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only services that match the filter are returned. All services are
         used to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these value
         obtained using bitwise 'OR' operator. For example, if the provided
         value is 6 then health state of services with HealthState value of
         OK (2) and Warning (4) will be returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn�t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type services_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationHealth
         <azure.servicefabric.models.ApplicationHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetHealth'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if deployed_applications_health_state_filter is not None:
            query_parameters['DeployedApplicationsHealthStateFilter'] = self._serialize.query("deployed_applications_health_state_filter", deployed_applications_health_state_filter, 'int')
        if services_health_state_filter is not None:
            query_parameters['ServicesHealthStateFilter'] = self._serialize.query("services_health_state_filter", services_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_application_health(
            self, application_id, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric application.

        Reports health state of the specified Service Fabric application. The
        report must contain the information about the source of the health
        report and property on which it is reported.
        The report is sent to a Service Fabric gateway Application, which
        forwards to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetApplicationHealth and check that the report appears in the
        HealthEvents section.
        .

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/ReportHealth'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def start_application_upgrade(
            self, application_id, application_upgrade_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Starts upgrading an application in the Service Fabric cluster.

        Validates the supplied application upgrade parameters and starts
        upgrading the application if the parameters are valid.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param application_upgrade_description: Describes the parameters for
         an application upgrade.
        :type application_upgrade_description:
         :class:`ApplicationUpgradeDescription
         <azure.servicefabric.models.ApplicationUpgradeDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/Upgrade'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(application_upgrade_description, 'ApplicationUpgradeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_application_upgrade(
            self, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets details for the latest upgrade performed on this application.

        Returns information about the state of the latest application upgrade
        along with details to aid debugging application health issues.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationUpgradeProgressInfo
         <azure.servicefabric.models.ApplicationUpgradeProgressInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetUpgradeProgress'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationUpgradeProgressInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def update_application_upgrade(
            self, application_id, application_upgrade_update_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Updates an ongoing application upgrade in the Service Fabric cluster.

        Updates the parameters of an ongoing application upgrade from the ones
        specified at the time of starting the application upgrade. This may
        be required to mitigate stuck application upgrades due to incorrect
        parameters or issues in the application to make progress.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param application_upgrade_update_description: Describes the
         parameters for updating an existing application upgrade.
        :type application_upgrade_update_description:
         :class:`ApplicationUpgradeUpdateDescription
         <azure.servicefabric.models.ApplicationUpgradeUpdateDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/UpdateUpgrade'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(application_upgrade_update_description, 'ApplicationUpgradeUpdateDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def resume_application_upgrade(
            self, application_id, upgrade_domain_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Resumes upgrading an application in the Service Fabric cluster.

        Resumes an unmonitored manual Service Fabric application upgrade.
        Service Fabric upgrades one upgrade domain at a time. For unmonitored
        manual upgrades, after Service Fabric finishes an upgrade domain, it
        waits for you to call this API before proceeding to the next upgrade
        domain.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param upgrade_domain_name: The name of the upgrade domain in which
         to resume the upgrade.
        :type upgrade_domain_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        resume_application_upgrade_description = models.ResumeApplicationUpgradeDescription(upgrade_domain_name=upgrade_domain_name)

        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/MoveToNextUpgradeDomain'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(resume_application_upgrade_description, 'ResumeApplicationUpgradeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def rollback_application_upgrade(
            self, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Starts rolling back the currently on-going upgrade of an application
        in the Service Fabric cluster.

        Starts rolling back the current application upgrade to the previous
        version. This API can only be used to rollback the current
        in-progress upgrade that is rolling forward to new version. If the
        application is not currently being upgraded use
        StartApplicationUpgrade API to upgrade it to desired version
        including rolling back to a previous version.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/RollbackUpgrade'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_deployed_application_info_list(
            self, node_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of applications deployed on a Service Fabric node.

        Gets the list of applications deployed on a Service Fabric node.

        :param node_name: The name of the node.
        :type node_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedApplicationInfo
         <azure.servicefabric.models.DeployedApplicationInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedApplicationInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_application_info(
            self, node_name, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about an application deployed on a Service Fabric
        node.

        Gets the information about an application deployed on a Service Fabric
        node.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedApplicationInfo
         <azure.servicefabric.models.DeployedApplicationInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedApplicationInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_application_health(
            self, node_name, application_id, events_health_state_filter=0, deployed_service_packages_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about health of an application deployed on a
        Service Fabric node.

        Gets the information about health of an application deployed on a
        Service Fabric node. Use EventsHealthStateFilter to optionally filter
        for the collection of HealthEvent objects reported on the deployed
        application based on health state. Use
        DeployedServicePackagesHealthStateFilter to optionally filter for
        DeployedServicePackageHealth children based on health state.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param deployed_service_packages_health_state_filter: Allows
         filtering of the deployed service package health state objects
         returned in the result of deployed application health query based on
         their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only deployed service packages that match the filter are returned.
         All deployed service packages are used to evaluate the aggregated
         health state of the deployed application.
         If not specified, all entries are returned.
         The state values are flag based enumeration, so the value can be a
         combination of these value obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of service
         packages with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type deployed_service_packages_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedApplicationHealth
         <azure.servicefabric.models.DeployedApplicationHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if deployed_service_packages_health_state_filter is not None:
            query_parameters['DeployedServicePackagesHealthStateFilter'] = self._serialize.query("deployed_service_packages_health_state_filter", deployed_service_packages_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedApplicationHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_application_health_using_policy(
            self, node_name, application_id, events_health_state_filter=0, deployed_service_packages_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about health of an application deployed on a
        Service Fabric node. using the specified policy.

        Gets the information about health of an application deployed on a
        Service Fabric node using the specified policy. Use
        EventsHealthStateFilter to optionally filter for the collection of
        HealthEvent objects reported on the deployed application based on
        health state. Use DeployedServicePackagesHealthStateFilter to
        optionally filter for DeployedServicePackageHealth children based on
        health state. Use ApplicationHealthPolicy to optionally override the
        health policies used to evaluate the health. This API only uses
        'ConsiderWarningAsError' field of the ApplicationHealthPolicy. The
        rest of the fields are ignored while evaluating the health of the
        deployed application.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param deployed_service_packages_health_state_filter: Allows
         filtering of the deployed service package health state objects
         returned in the result of deployed application health query based on
         their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only deployed service packages that match the filter are returned.
         All deployed service packages are used to evaluate the aggregated
         health state of the deployed application.
         If not specified, all entries are returned.
         The state values are flag based enumeration, so the value can be a
         combination of these value obtained using bitwise 'OR' operator.
         For example, if the provided value is 6 then health state of service
         packages with HealthState value of OK (2) and Warning (4) are
         returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type deployed_service_packages_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedApplicationHealth
         <azure.servicefabric.models.DeployedApplicationHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if deployed_service_packages_health_state_filter is not None:
            query_parameters['DeployedServicePackagesHealthStateFilter'] = self._serialize.query("deployed_service_packages_health_state_filter", deployed_service_packages_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedApplicationHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_deployed_application_health(
            self, node_name, application_id, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric application deployed on a
        Service Fabric node.

        Reports health state of the application deployed on a Service Fabric
        node. The report must contain the information about the source of the
        health report and property on which it is reported.
        The report is sent to a Service Fabric gateway Service, which forwards
        to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, get
        deployed application health and check that the report appears in the
        HealthEvents section.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/ReportHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_application_manifest(
            self, application_type_name, application_type_version, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the manifest describing an application type.

        Gets the manifest describing an application type. The response
        contains the application manifest XML as a string.

        :param application_type_name: The name of the application type.
        :type application_type_name: str
        :param application_type_version: The version of the application type.
        :type application_type_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationTypeManifest
         <azure.servicefabric.models.ApplicationTypeManifest>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ApplicationTypes/{applicationTypeName}/$/GetApplicationManifest'
        path_format_arguments = {
            'applicationTypeName': self._serialize.url("application_type_name", application_type_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['ApplicationTypeVersion'] = self._serialize.query("application_type_version", application_type_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationTypeManifest', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_info_list(
            self, application_id, service_type_name=None, continuation_token=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about all services belonging to the application
        specified by the application id.

        Returns the information about all services belonging to the
        application specified by the application id.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_type_name: The service type name used to filter the
         services to query for.
        :type service_type_name: str
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedServiceInfoList
         <azure.servicefabric.models.PagedServiceInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetServices'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if service_type_name is not None:
            query_parameters['ServiceTypeName'] = self._serialize.query("service_type_name", service_type_name, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedServiceInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_info(
            self, application_id, service_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about the specific service belonging to a Service
        Fabric application.

        Returns the information about specified service belonging to the
        specified Service Fabric application.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceInfo <azure.servicefabric.models.ServiceInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetServices/{serviceId}'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_application_name_info(
            self, service_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the name of the Service Fabric application for a service.

        The GetApplicationName endpoint returns the name of the application
        for the specified service.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ApplicationNameInfo
         <azure.servicefabric.models.ApplicationNameInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/GetApplicationName'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ApplicationNameInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def create_service(
            self, application_id, service_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Creates the specified service.

        Creates the specified service.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_description: The configuration for the service.
        :type service_description: :class:`ServiceDescription
         <azure.servicefabric.models.ServiceDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetServices/$/Create'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(service_description, 'ServiceDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def create_service_from_template(
            self, application_id, service_from_template_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Creates a Service Fabric service from the service template defined in
        the application manifest.

        Creates a Service Fabric service from the service template defined in
        the application manifest.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_from_template_description: Describes the service that
         needs to be created from the template defined in the application
         manifest.
        :type service_from_template_description:
         :class:`ServiceFromTemplateDescription
         <azure.servicefabric.models.ServiceFromTemplateDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Applications/{applicationId}/$/GetServices/$/CreateFromTemplate'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(service_from_template_description, 'ServiceFromTemplateDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def delete_service(
            self, service_id, force_remove=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing Service Fabric service.

        Deletes an existing Service Fabric service. A service must be created
        before it can be deleted. By default Service Fabric will try to close
        service replicas in a graceful manner and then delete the service.
        However if service is having issues closing the replica gracefully,
        the delete operation may take a long time or get stuck. Use the
        optional ForceRemove flag to skip the graceful close sequence and
        forcefully delete the service.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param force_remove: Remove a Service Fabric application or service
         forcefully without going through the graceful shutdown sequence.
         This parameter can be used to forcefully delete an application or
         service for which delete is timing out due to issues in the service
         code that prevents graceful close of replicas.
        :type force_remove: bool
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/Delete'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if force_remove is not None:
            query_parameters['ForceRemove'] = self._serialize.query("force_remove", force_remove, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def update_service(
            self, service_id, service_update_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Updates the specified service using the given update description.

        Updates the specified service using the given update description.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param service_update_description: The updated configuration for the
         service.
        :type service_update_description: :class:`ServiceUpdateDescription
         <azure.servicefabric.models.ServiceUpdateDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/Update'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(service_update_description, 'ServiceUpdateDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_service_description(
            self, service_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the description of an existing Service Fabric service.

        Gets the description of an existing Service Fabric service. A service
        must be created before its description can be obtained.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceDescription
         <azure.servicefabric.models.ServiceDescription>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/GetDescription'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceDescription', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_health(
            self, service_id, events_health_state_filter=0, partitions_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of the specified Service Fabric service.

        Gets the health information of the specified service.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the service based on the health state.
        Use PartitionsHealthStateFilter to filter the collection of partitions
        returned.
        If you specify a service that does not exist in the health store, this
        cmdlet returns an error.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param partitions_health_state_filter: Allows filtering of the
         partitions health state objects returned in the result of service
         health query based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only partitions that match the filter are returned. All partitions
         are used to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these value
         obtained using bitwise 'OR' operator. For example, if the provided
         value is 6 then health state of partitions with HealthState value of
         OK (2) and Warning (4) will be returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn't match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type partitions_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceHealth
         <azure.servicefabric.models.ServiceHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/GetHealth'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if partitions_health_state_filter is not None:
            query_parameters['PartitionsHealthStateFilter'] = self._serialize.query("partitions_health_state_filter", partitions_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_health_using_policy(
            self, service_id, events_health_state_filter=0, partitions_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of the specified Service Fabric service, by using the
        specified health policy.

        Gets the health information of the specified service.
        If the application health policy is specified, the health evaluation
        uses it to get the aggregated health state.
        If the policy is not specified, the health evaluation uses the
        application health policy defined in the application manifest, or the
        default health policy, if no policy is defined in the manifest.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the service based on the health state.
        Use PartitionsHealthStateFilter to filter the collection of partitions
        returned.
        If you specify a service that does not exist in the health store, this
        cmdlet returns an error.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param partitions_health_state_filter: Allows filtering of the
         partitions health state objects returned in the result of service
         health query based on their health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only partitions that match the filter are returned. All partitions
         are used to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these value
         obtained using bitwise 'OR' operator. For example, if the provided
         value is 6 then health state of partitions with HealthState value of
         OK (2) and Warning (4) will be returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn't match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type partitions_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceHealth
         <azure.servicefabric.models.ServiceHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/GetHealth'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if partitions_health_state_filter is not None:
            query_parameters['PartitionsHealthStateFilter'] = self._serialize.query("partitions_health_state_filter", partitions_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_service_health(
            self, service_id, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric service.

        Reports health state of the specified Service Fabric service. The
        report must contain the information about the source of the health
        report and property on which it is reported.
        The report is sent to a Service Fabric gateway Service, which forwards
        to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetServiceHealth and check that the report appears in the
        HealthEvents section.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/ReportHealth'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def resolve_service(
            self, service_id, partition_key_type=None, partition_key_value=None, previous_rsp_version=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Resolve a Service Fabric partition.

        Resolve a Service Fabric service partition, to get the endpoints of
        the service replicas.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_key_type: Key type for the partition. This parameter
         is required if the partition scheme for the service is Int64Range or
         Named. The possible values are following.
         - None (1) - Indicates that the the PartitionKeyValue parameter is
         not specified. This is valid for the partitions with partitioning
         scheme as Singleton. This is the default value. The value is 1.
         - Int64Range (2) - Indicates that the the PartitionKeyValue parameter
         is an int64 partition key. This is valid for the partitions with
         partitioning scheme as Int64Range. The value is 2.
         - Named (3) - Indicates that the the PartitionKeyValue parameter is a
         name of the partition. This is valid for the partitions with
         partitioning scheme as Named. The value is 3.
        :type partition_key_type: int
        :param partition_key_value: Partition key. This is required if the
         partition scheme for the service is Int64Range or Named.
        :type partition_key_value: str
        :param previous_rsp_version: The value in the Version field of the
         response that was received previously. This is required if the user
         knows that the result that was got previously is stale.
        :type previous_rsp_version: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ResolvedServicePartition
         <azure.servicefabric.models.ResolvedServicePartition>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/ResolvePartition'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if partition_key_type is not None:
            query_parameters['PartitionKeyType'] = self._serialize.query("partition_key_type", partition_key_type, 'int')
        if partition_key_value is not None:
            query_parameters['PartitionKeyValue'] = self._serialize.query("partition_key_value", partition_key_value, 'str', skip_quote=True)
        if previous_rsp_version is not None:
            query_parameters['PreviousRspVersion'] = self._serialize.query("previous_rsp_version", previous_rsp_version, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ResolvedServicePartition', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_partition_info_list(
            self, service_id, continuation_token=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of partitions of a Service Fabric service.

        Gets the list of partitions of a Service Fabric service. The response
        include the partition id, partitioning scheme information, keys
        supported by the partition, status, health and other details about
        the partition.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedServicePartitionInfoList
         <azure.servicefabric.models.PagedServicePartitionInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/{serviceId}/$/GetPartitions'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedServicePartitionInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_partition_info(
            self, partition_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about a Service Fabric partition.

        The Partitions endpoint returns information about the specified
        partition. The response include the partition id, partitioning scheme
        information, keys supported by the partition, status, health and
        other details about the partition.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServicePartitionInfo
         <azure.servicefabric.models.ServicePartitionInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServicePartitionInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_service_name_info(
            self, partition_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the name of the Service Fabric service for a partition.

        The GetServiceName endpoint returns the name of the service for the
        specified partition.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ServiceNameInfo
         <azure.servicefabric.models.ServiceNameInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetServiceName'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ServiceNameInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_partition_health(
            self, partition_id, events_health_state_filter=0, replicas_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of the specified Service Fabric partition.

        Gets the health information of the specified partition.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the service based on the health state.
        Use ReplicasHealthStateFilter to filter the collection of
        ReplicaHealthState objects on the partition.
        If you specify a partition that does not exist in the health store,
        this cmdlet returns an error.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param replicas_health_state_filter: Allows filtering the collection
         of ReplicaHealthState objects on the partition. The value can be
         obtained from members or bitwise operations on members of
         HealthStateFilter. Only replicas that match the filter will be
         returned. All replicas will be used to evaluate the aggregated
         health state. If not specified, all entries will be returned.The
         state values are flag based enumeration, so the value could be a
         combination of these value obtained using bitwise 'OR' operator. For
         example, If the provided value is 6 then all of the events with
         HealthState value of OK (2) and Warning (4) will be returned. The
         possible values for this parameter include integer value of one of
         the following health states.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type replicas_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionHealth
         <azure.servicefabric.models.PartitionHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if replicas_health_state_filter is not None:
            query_parameters['ReplicasHealthStateFilter'] = self._serialize.query("replicas_health_state_filter", replicas_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_partition_health_using_policy(
            self, partition_id, events_health_state_filter=0, replicas_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of the specified Service Fabric partition, by using
        the specified health policy.

        Gets the health information of the specified partition.
        If the application health policy is specified, the health evaluation
        uses it to get the aggregated health state.
        If the policy is not specified, the health evaluation uses the
        application health policy defined in the application manifest, or the
        default health policy, if no policy is defined in the manifest.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the partition based on the health state.
        Use ReplicasHealthStateFilter to filter the collection of
        ReplicaHealthState objects on the partition. Use
        ApplicationHealthPolicy in the POST body to override the health
        policies used to evaluate the health.
        If you specify a partition that does not exist in the health store,
        this cmdlet returns an error.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param replicas_health_state_filter: Allows filtering the collection
         of ReplicaHealthState objects on the partition. The value can be
         obtained from members or bitwise operations on members of
         HealthStateFilter. Only replicas that match the filter will be
         returned. All replicas will be used to evaluate the aggregated
         health state. If not specified, all entries will be returned.The
         state values are flag based enumeration, so the value could be a
         combination of these value obtained using bitwise 'OR' operator. For
         example, If the provided value is 6 then all of the events with
         HealthState value of OK (2) and Warning (4) will be returned. The
         possible values for this parameter include integer value of one of
         the following health states.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type replicas_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionHealth
         <azure.servicefabric.models.PartitionHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if replicas_health_state_filter is not None:
            query_parameters['ReplicasHealthStateFilter'] = self._serialize.query("replicas_health_state_filter", replicas_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_partition_health(
            self, partition_id, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric partition.

        Reports health state of the specified Service Fabric partition. The
        report must contain the information about the source of the health
        report and property on which it is reported.
        The report is sent to a Service Fabric gateway Partition, which
        forwards to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetPartitionHealth and check that the report appears in the
        HealthEvents section.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/ReportHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_partition_load_information(
            self, partition_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the load of the specified Service Fabric partition.

        Returns information about the specified partition.
        The response includes a list of load information.
        Each information includes load metric name, value and last reported
        time in UTC.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionLoadInformation
         <azure.servicefabric.models.PartitionLoadInformation>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetLoadInformation'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionLoadInformation', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def reset_partition_load(
            self, partition_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Resets the current load of a Service Fabric partition.

        Resets the current load of a Service Fabric partition to the default
        load for the service.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/ResetLoad'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def recover_partition(
            self, partition_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Indicates to the Service Fabric cluster that it should attempt to
        recover a specific partition which is currently stuck in quorum loss.

        Indicates to the Service Fabric cluster that it should attempt to
        recover a specific partition which is currently stuck in quorum loss.
        This operation should only be performed if it is known that the
        replicas that are down cannot be recovered. Incorrect use of this API
        can cause potential data loss.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/Recover'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def recover_service_partitions(
            self, service_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Indicates to the Service Fabric cluster that it should attempt to
        recover the specified service which is currently stuck in quorum
        loss.

        Indicates to the Service Fabric cluster that it should attempt to
        recover the specified service which is currently stuck in quorum
        loss. This operation should only be performed if it is known that the
        replicas that are down cannot be recovered. Incorrect use of this API
        can cause potential data loss.

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Services/$/{serviceId}/$/GetPartitions/$/Recover'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def recover_system_partitions(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Indicates to the Service Fabric cluster that it should attempt to
        recover the system services which are currently stuck in quorum loss.

        Indicates to the Service Fabric cluster that it should attempt to
        recover the system services which are currently stuck in quorum loss.
        This operation should only be performed if it is known that the
        replicas that are down cannot be recovered. Incorrect use of this API
        can cause potential data loss.

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/RecoverSystemPartitions'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def recover_all_partitions(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Indicates to the Service Fabric cluster that it should attempt to
        recover any services (including system services) which are currently
        stuck in quorum loss.

        Indicates to the Service Fabric cluster that it should attempt to
        recover any services (including system services) which are currently
        stuck in quorum loss. This operation should only be performed if it
        is known that the replicas that are down cannot be recovered.
        Incorrect use of this API can cause potential data loss.

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/RecoverAllPartitions'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_replica_info_list(
            self, partition_id, continuation_token=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about replicas of a Service Fabric service
        partition.

        The GetReplicas endpoint returns information about the replicas of the
        specified partition. The respons include the id, role, status,
        health, node name, uptime, and other details about the replica.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedReplicaInfoList
         <azure.servicefabric.models.PagedReplicaInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetReplicas'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedReplicaInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_replica_info(
            self, partition_id, replica_id, continuation_token=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about a replica of a Service Fabric partition.

        The respons include the id, role, status, health, node name, uptime,
        and other details about the replica.

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ReplicaInfo <azure.servicefabric.models.ReplicaInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetReplicas/{replicaId}'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ReplicaInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_replica_health(
            self, partition_id, replica_id, events_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric stateful service replica or
        stateless service instance.

        Gets the health of a Service Fabric replica.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the replica based on the health state.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ReplicaHealth
         <azure.servicefabric.models.ReplicaHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ReplicaHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_replica_health_using_policy(
            self, partition_id, replica_id, events_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the health of a Service Fabric stateful service replica or
        stateless service instance using the specified policy.

        Gets the health of a Service Fabric stateful service replica or
        stateless service instance.
        Use EventsHealthStateFilter to filter the collection of health events
        reported on the cluster based on the health state.
        Use ApplicationHealthPolicy to optionally override the health policies
        used to evaluate the health. This API only uses
        'ConsiderWarningAsError' field of the ApplicationHealthPolicy. The
        rest of the fields are ignored while evaluating the health of the
        replica.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ReplicaHealth
         <azure.servicefabric.models.ReplicaHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ReplicaHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_replica_health(
            self, partition_id, replica_id, health_information, service_kind="Stateful", timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric replica.

        Reports health state of the specified Service Fabric replica. The
        report must contain the information about the source of the health
        report and property on which it is reported.
        The report is sent to a Service Fabric gateway Replica, which forwards
        to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, run
        GetReplicaHealth and check that the report appears in the
        HealthEvents section.
        .

        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param service_kind: The kind of service replica (Stateless or
         Stateful) for which the health is being reported. Following are the
         possible values.
         - Stateless - Does not use Service Fabric to make its state highly
         available or reliable. The value is 1
         - Stateful - Uses Service Fabric to make its state or part of its
         state highly available and reliable. The value is 2.
         . Possible values include: 'Stateless', 'Stateful'
        :type service_kind: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/ReportHealth'
        path_format_arguments = {
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['ServiceKind'] = self._serialize.query("service_kind", service_kind, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_deployed_service_replica_info_list(
            self, node_name, application_id, partition_id=None, service_manifest_name=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of replicas deployed on a Service Fabric node.

        Gets the list containing the information about replicas deployed on a
        Service Fabric node. The information include partition id, replica
        id, status of the replica, name of the service, name of the service
        type and other information. Use PartitionId or ServiceManifestName
        query parameters to return information about the deployed replicas
        matching the specified values for those parameters.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param service_manifest_name: The name of a service manifest
         registered as part of an application type in a Service Fabric
         cluster.
        :type service_manifest_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedServiceReplicaInfo
         <azure.servicefabric.models.DeployedServiceReplicaInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetReplicas'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if partition_id is not None:
            query_parameters['PartitionId'] = self._serialize.query("partition_id", partition_id, 'str')
        if service_manifest_name is not None:
            query_parameters['ServiceManifestName'] = self._serialize.query("service_manifest_name", service_manifest_name, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 204]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedServiceReplicaInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_replica_detail_info(
            self, node_name, partition_id, replica_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the details of replica deployed on a Service Fabric node.

        Gets the details of the replica deployed on a Service Fabric node. The
        information include service kind, service name, current service
        operation, current service operation start date time, partition id,
        replica/instance id, reported load and other information.

        :param node_name: The name of the node.
        :type node_name: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedServiceReplicaDetailInfo
         <azure.servicefabric.models.DeployedServiceReplicaDetailInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetDetail'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedServiceReplicaDetailInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def restart_replica(
            self, node_name, partition_id, replica_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Restarts a service replica of a persisted service running on a node.

        Restarts a service replica of a persisted service running on a node.
        Warning - There are no safety checks performed when this API is used.
        Incorrect use of this API can lead to availability loss for stateful
        services.

        :param node_name: The name of the node.
        :type node_name: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/Restart'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def remove_replica(
            self, node_name, partition_id, replica_id, force_remove=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Removes a service replica running on a node.

        This API simulates a Service Fabric replica failure by removing a
        replica from a Service Fabric cluster. The removal closes the
        replica, transitions the replica to the role None, and then removes
        all of the state information of the replica from the cluster. This
        API tests the replica state removal path, and simulates the report
        fault permanent path through client APIs. Warning - There are no
        safety checks performed when this API is used. Incorrect use of this
        API can lead to data loss for stateful services.In addition, the
        forceRemove flag impacts all other replicas hosted in the same
        process.

        :param node_name: The name of the node.
        :type node_name: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param replica_id: The identifier of the replica.
        :type replica_id: str
        :param force_remove: Remove a Service Fabric application or service
         forcefully without going through the graceful shutdown sequence.
         This parameter can be used to forcefully delete an application or
         service for which delete is timing out due to issues in the service
         code that prevents graceful close of replicas.
        :type force_remove: bool
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/Delete'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True),
            'replicaId': self._serialize.url("replica_id", replica_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if force_remove is not None:
            query_parameters['ForceRemove'] = self._serialize.query("force_remove", force_remove, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_deployed_service_package_info_list(
            self, node_name, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of service packages deployed on a Service Fabric node.

        Returns the information about the service packages deployed on a
        Service Fabric node for the given application.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedServicePackageInfo
         <azure.servicefabric.models.DeployedServicePackageInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedServicePackageInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_package_info_list_by_name(
            self, node_name, application_id, service_package_name, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of service packages deployed on a Service Fabric node
        matching exactly the specified name.

        Returns the information about the service packages deployed on a
        Service Fabric node for the given application. These results are of
        service packages whose name match exactly the service package name
        specified as the parameter.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_package_name: The name of the service package.
        :type service_package_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedServicePackageInfo
         <azure.servicefabric.models.DeployedServicePackageInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'servicePackageName': self._serialize.url("service_package_name", service_package_name, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedServicePackageInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_package_health(
            self, node_name, application_id, service_package_name, events_health_state_filter=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about health of an service package for a specific
        application deployed for a Service Fabric node and application.

        Gets the information about health of service package for a specific
        application deployed on a Service Fabric node. Use
        EventsHealthStateFilter to optionally filter for the collection of
        HealthEvent objects reported on the deployed service package based on
        health state.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_package_name: The name of the service package.
        :type service_package_name: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedServicePackageHealth
         <azure.servicefabric.models.DeployedServicePackageHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'servicePackageName': self._serialize.url("service_package_name", service_package_name, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedServicePackageHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_deployed_service_package_health_using_policy(
            self, node_name, application_id, service_package_name, events_health_state_filter=0, application_health_policy=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the information about health of service package for a specific
        application deployed on a Service Fabric node using the specified
        policy.

        Gets the information about health of an service package for a specific
        application deployed on a Service Fabric node. using the specified
        policy. Use EventsHealthStateFilter to optionally filter for the
        collection of HealthEvent objects reported on the deployed service
        package based on health state. Use ApplicationHealthPolicy to
        optionally override the health policies used to evaluate the health.
        This API only uses 'ConsiderWarningAsError' field of the
        ApplicationHealthPolicy. The rest of the fields are ignored while
        evaluating the health of the deployed service package.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_package_name: The name of the service package.
        :type service_package_name: str
        :param events_health_state_filter: Allows filtering the collection of
         HealthEvent objects returned based on health state.
         The possible values for this parameter include integer value of one
         of the following health states.
         Only events that match the filter are returned. All events are used
         to evaluate the aggregated health state.
         If not specified, all entries are returned. The state values are flag
         based enumeration, so the value could be a combination of these
         value obtained using bitwise 'OR' operator. For example, If the
         provided value is 6 then all of the events with HealthState value of
         OK (2) and Warning (4) are returned.
         - Default - Default value. Matches any HealthState. The value is
         zero.
         - None - Filter that doesn’t match any HealthState value. Used in
         order to return no results on a given collection of states. The
         value is 1.
         - Ok - Filter that matches input with HealthState value Ok. The value
         is 2.
         - Warning - Filter that matches input with HealthState value Warning.
         The value is 4.
         - Error - Filter that matches input with HealthState value Error. The
         value is 8.
         - All - Filter that matches input with any HealthState value. The
         value is 65535.
        :type events_health_state_filter: int
        :param application_health_policy: Describes the health policies used
         to evaluate the health of an application or one of its children.
         If not present, the health evaluation uses the health policy from
         application manifest or the default health policy.
        :type application_health_policy: :class:`ApplicationHealthPolicy
         <azure.servicefabric.models.ApplicationHealthPolicy>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`DeployedServicePackageHealth
         <azure.servicefabric.models.DeployedServicePackageHealth>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/GetHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'servicePackageName': self._serialize.url("service_package_name", service_package_name, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if events_health_state_filter is not None:
            query_parameters['EventsHealthStateFilter'] = self._serialize.query("events_health_state_filter", events_health_state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if application_health_policy is not None:
            body_content = self._serialize.body(application_health_policy, 'ApplicationHealthPolicy')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DeployedServicePackageHealth', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def report_deployed_service_package_health(
            self, node_name, application_id, service_package_name, health_information, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Sends a health report on the Service Fabric deployed service package.

        Reports health state of the service package of the application
        deployed on a Service Fabric node. The report must contain the
        information about the source of the health report and property on
        which it is reported.
        The report is sent to a Service Fabric gateway Service, which forwards
        to the health store.
        The report may be accepted by the gateway, but rejected by the health
        store after extra validation.
        For example, the health store may reject the report because of an
        invalid parameter, like a stale sequence number.
        To see whether the report was applied in the health store, get
        deployed service package health and check that the report appears in
        the HealthEvents section.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_package_name: The name of the service package.
        :type service_package_name: str
        :param health_information: Describes the health information for the
         health report. This information needs to be present in all of the
         health reports sent to the health manager.
        :type health_information: :class:`HealthInformation
         <azure.servicefabric.models.HealthInformation>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/ReportHealth'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True),
            'servicePackageName': self._serialize.url("service_package_name", service_package_name, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(health_information, 'HealthInformation')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def deployed_service_package_to_node(
            self, node_name, deploy_service_package_to_node_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Downloads packages associated with specified service manifest to image
        cache on specified node.

        Downloads packages associated with specified service manifest to image
        cache on specified node.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param deploy_service_package_to_node_description: Describes
         information for deploying a service package to a Service Fabric node.
        :type deploy_service_package_to_node_description:
         :class:`DeployServicePackageToNodeDescription
         <azure.servicefabric.models.DeployServicePackageToNodeDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/DeployServicePackage'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(deploy_service_package_to_node_description, 'DeployServicePackageToNodeDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_deployed_code_package_info_list(
            self, node_name, application_id, service_manifest_name=None, code_package_name=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of code packages deployed on a Service Fabric node.

        Gets the list of code packages deployed on a Service Fabric node for
        the given application.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param service_manifest_name: The name of a service manifest
         registered as part of an application type in a Service Fabric
         cluster.
        :type service_manifest_name: str
        :param code_package_name: The name of code package specified in
         service manifest registered as part of an application type in a
         Service Fabric cluster.
        :type code_package_name: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`DeployedCodePackageInfo
         <azure.servicefabric.models.DeployedCodePackageInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if service_manifest_name is not None:
            query_parameters['ServiceManifestName'] = self._serialize.query("service_manifest_name", service_manifest_name, 'str')
        if code_package_name is not None:
            query_parameters['CodePackageName'] = self._serialize.query("code_package_name", code_package_name, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[DeployedCodePackageInfo]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def restart_deployed_code_package(
            self, node_name, application_id, restart_deployed_code_package_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Restarts a code package deployed on a Service Fabric node in a
        cluster.

        Restarts a code package deployed on a Service Fabric node in a
        cluster. This aborts the code package process, which will restart all
        the user service replicas hosted in that process.

        :param node_name: The name of the node.
        :type node_name: str
        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param restart_deployed_code_package_description: Describes the
         deployed code package on Service Fabric node to restart.
        :type restart_deployed_code_package_description:
         :class:`RestartDeployedCodePackageDescription
         <azure.servicefabric.models.RestartDeployedCodePackageDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages/$/Restart'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str'),
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(restart_deployed_code_package_description, 'RestartDeployedCodePackageDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def create_compose_application(
            self, create_compose_application_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Creates a Service Fabric compose application.

        Creates a Service Fabric compose application.

        :param create_compose_application_description: Describes the compose
         application that needs to be created.
        :type create_compose_application_description:
         :class:`CreateComposeApplicationDescription
         <azure.servicefabric.models.CreateComposeApplicationDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0-preview"

        # Construct URL
        url = '/ComposeDeployments/$/Create'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(create_compose_application_description, 'CreateComposeApplicationDescription')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_compose_application_status(
            self, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets information about a Service Fabric compose application.

        Returns the status of compose application that was created or in the
        process of being created in the Service Fabric cluster and whose name
        matches the one specified as the parameter. The response includes the
        name, status and other details about the application.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ComposeApplicationStatusInfo
         <azure.servicefabric.models.ComposeApplicationStatusInfo>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0-preview"

        # Construct URL
        url = '/ComposeDeployments/{applicationId}'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ComposeApplicationStatusInfo', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_compose_application_status_list(
            self, continuation_token=None, max_results=0, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the list of compose applications created in the Service Fabric
        cluster.

        Gets the status about the compose applications that were created or in
        the process of being created in the Service Fabric cluster. The
        response includes the name, status and other details about the
        compose application. If the applications do not fit in a page, one
        page of results is returned as well as a continuation token which can
        be used to get the next page.

        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param max_results: The maximum number of results to be returned as
         part of the paged queries. This parameter defines the upper bound on
         the number of results returned. The results returned can be less
         than the specified maximum results if they do not fit in the message
         as per the max message size restrictions defined in the
         configuration. If this parameter is zero or not specified, the paged
         queries includes as much results as possible that fit in the return
         message.
        :type max_results: long
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PagedComposeApplicationStatusInfoList
         <azure.servicefabric.models.PagedComposeApplicationStatusInfoList>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0-preview"

        # Construct URL
        url = '/ComposeDeployments'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if max_results is not None:
            query_parameters['MaxResults'] = self._serialize.query("max_results", max_results, 'long', minimum=0)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedComposeApplicationStatusInfoList', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def remove_compose_application(
            self, application_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Deletes an existing Service Fabric compose application from cluster.

        Deletes an existing Service Fabric compose application. An application
        must be created before it can be deleted.

        :param application_id: The identity of the application. This is
         typically the full name of the application without the 'fabric:' URI
         scheme.
        :type application_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "4.0-preview"

        # Construct URL
        url = '/ComposeDeployments/{applicationId}/$/Delete'
        path_format_arguments = {
            'applicationId': self._serialize.url("application_id", application_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def start_chaos(
            self, chaos_parameters, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Starts Chaos in the cluster.

        If Chaos is not already running in the cluster, it starts Chaos with
        the passed in Chaos parameters.
        If Chaos is already running when this call is made, the call fails
        with the error code FABRIC_E_CHAOS_ALREADY_RUNNING.
        Please refer to the article [Induce controlled Chaos in Service Fabric
        clusters](https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-controlled-chaos)
        for more details.
        .

        :param chaos_parameters: Describes all the parameters to configure a
         Chaos run.
        :type chaos_parameters: :class:`ChaosParameters
         <azure.servicefabric.models.ChaosParameters>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Tools/Chaos/$/Start'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(chaos_parameters, 'ChaosParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def stop_chaos(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Stops Chaos in the cluster if it is already running, otherwise it does
        nothing.

        Stops Chaos from scheduling further faults; but, the in-flight faults
        are not affected.

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Tools/Chaos/$/Stop'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_chaos_report(
            self, continuation_token=None, start_time_utc=None, end_time_utc=None, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the next segment of the Chaos report based on the passed-in
        continuation token or the passed-in time-range.

        You can either specify the ContinuationTokenOptionalQueryParam to get
        the next segment of the Chaos report or you can specify the time-range
        through StartTimeUtcOptionalQueryParam and
        EndTimeUtcOptionalQueryParam, but you cannot specify both the
        ContinuationTokenOptionalQueryParam and the time-range at the same
        time.
        When the Chaos report contains more than 100 Chaos events, the Chaos
        report is returned in segments where a segment contains no more than
        100 Chaos events.
        .

        :param continuation_token: The continuation token parameter is used
         to obtain next set of results. A continuation token with a non empty
         value is included in the response of the API when the results from
         the system do not fit in a single response. When this value is
         passed to the next API call, the API returns next set of results. If
         there are no further results then the continuation token does not
         contain a value. The value of this parameter should not be URL
         encoded.
        :type continuation_token: str
        :param start_time_utc: Start of the time range for which a Chaos
         report is to be generated.
        :type start_time_utc: str
        :param end_time_utc: End of the time range for which a Chaos report
         is to be generated.
        :type end_time_utc: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ChaosReport <azure.servicefabric.models.ChaosReport>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Tools/Chaos/$/Report'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if continuation_token is not None:
            query_parameters['ContinuationToken'] = self._serialize.query("continuation_token", continuation_token, 'str', skip_quote=True)
        if start_time_utc is not None:
            query_parameters['StartTimeUtc'] = self._serialize.query("start_time_utc", start_time_utc, 'str')
        if end_time_utc is not None:
            query_parameters['EndTimeUtc'] = self._serialize.query("end_time_utc", end_time_utc, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ChaosReport', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def upload_file(
            self, content_path, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Uploads contents of the file to the image store.

        Uploads contents of the file to the image store. Use this API if the
        file is small enough to upload again if the connection fails. The
        file's data needs to be added to the request body. The contents will
        be uploaded to the specified path.

        :param content_path: Relative path to file or folder in the image
         store from its root.
        :type content_path: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ImageStore/{contentPath}'
        path_format_arguments = {
            'contentPath': self._serialize.url("content_path", content_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_image_store_content(
            self, content_path, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the image store content information.

        Returns the information about the image store content at the specified
        contentPath relative to the root of the image store.

        :param content_path: Relative path to file or folder in the image
         store from its root.
        :type content_path: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ImageStoreContent
         <azure.servicefabric.models.ImageStoreContent>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ImageStore/{contentPath}'
        path_format_arguments = {
            'contentPath': self._serialize.url("content_path", content_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageStoreContent', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def delete_image_store_content(
            self, content_path, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Deletes existing image store content.

        Deletes existing image store content being found within the given
        image store relative path. This can be used to delete uploaded
        application packages once they are provisioned.

        :param content_path: Relative path to file or folder in the image
         store from its root.
        :type content_path: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ImageStore/{contentPath}'
        path_format_arguments = {
            'contentPath': self._serialize.url("content_path", content_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_image_store_root_content(
            self, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the content information at the root of the image store.

        Returns the information about the image store content at the root of
        the image store.

        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ImageStoreContent
         <azure.servicefabric.models.ImageStoreContent>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ImageStore'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ImageStoreContent', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def copy_image_store_content(
            self, image_store_copy_description, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Copies image store content internally.

        Copies the image store content from the source image store relative
        path to the destination image store relative path.

        :param image_store_copy_description: Describes the copy description
         for the image store.
        :type image_store_copy_description: :class:`ImageStoreCopyDescription
         <azure.servicefabric.models.ImageStoreCopyDescription>`
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/ImageStore/$/Copy'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(image_store_copy_description, 'ImageStoreCopyDescription')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def invoke_infrastructure_command(
            self, command, service_id=None, timeout=60, custom_headers=None, raw=False, callback=None, **operation_config):
        """Invokes an administrative command on the given Infrastructure Service
        instance.

        For clusters that have one or more instances of the Infrastructure
        Service configured,
        this API provides a way to send infrastructure-specific commands to a
        particular
        instance of the Infrastructure Service.
        Available commands and their corresponding response formats vary
        depending upon
        the infrastructure on which the cluster is running.
        This API supports the Service Fabric platform; it is not meant to be
        used directly from your code.
        .

        :param command: The text of the command to be invoked. The content of
         the command is infrastructure-specific.
        :type command: str
        :param service_id: The identity of the infrastructure service. This
         is  the full name of the infrastructure service without the
         'fabric:' URI scheme. This parameter required only for the cluster
         that have more than one instance of infrastructure service running.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: Generator
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/InvokeInfrastructureCommand'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['Command'] = self._serialize.query("command", command, 'str')
        if service_id is not None:
            query_parameters['ServiceId'] = self._serialize.query("service_id", service_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._client.stream_download(response, callback)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def invoke_infrastructure_query(
            self, command, service_id=None, timeout=60, custom_headers=None, raw=False, callback=None, **operation_config):
        """Invokes a read-only query on the given infrastructure service
        instance.

        For clusters that have one or more instances of the Infrastructure
        Service configured,
        this API provides a way to send infrastructure-specific queries to a
        particular
        instance of the Infrastructure Service.
        Available commands and their corresponding response formats vary
        depending upon
        the infrastructure on which the cluster is running.
        This API supports the Service Fabric platform; it is not meant to be
        used directly from your code.
        .

        :param command: The text of the command to be invoked. The content of
         the command is infrastructure-specific.
        :type command: str
        :param service_id: The identity of the infrastructure service. This
         is  the full name of the infrastructure service without the
         'fabric:' URI scheme. This parameter required only for the cluster
         that have more than one instance of infrastructure service running.
        :type service_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: Generator
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/$/InvokeInfrastructureQuery'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['Command'] = self._serialize.query("command", command, 'str')
        if service_id is not None:
            query_parameters['ServiceId'] = self._serialize.query("service_id", service_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._client.stream_download(response, callback)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def start_data_loss(
            self, service_id, partition_id, operation_id, data_loss_mode, timeout=60, custom_headers=None, raw=False, **operation_config):
        """This API will induce data loss for the specified partition. It will
        trigger a call to the OnDataLossAsync API of the partition.

        This API will induce data loss for the specified partition. It will
        trigger a call to the OnDataLoss API of the partition.
        Actual data loss will depend on the specified DataLossMode
        PartialDataLoss - Only a quorum of replicas are removed and OnDataLoss
        is triggered for the partition but actual data loss depends on the
        presence of in-flight replication.
        FullDataLoss - All replicas are removed hence all data is lost and
        OnDataLoss is triggered.
        This API should only be called with a stateful service as the target.
        Calling this API with a system service as the target is not advised.
        Note:  Once this API has been called, it cannot be reversed. Calling
        CancelOperation will only stop execution and clean up internal system
        state.
        It will not restore data if the command has progressed far enough to
        cause data loss.
        Call the GetDataLossProgress API with the same OperationId to return
        information on the operation started with this API.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param data_loss_mode: This enum is passed to the StartDataLoss API
         to indicate what type of data loss to induce.
         - Invalid - Reserved.  Do not pass into API.
         - PartialDataLoss - PartialDataLoss option will cause a quorum of
         replicas to go down, triggering an OnDataLoss event in the system
         for the given partition.
         - FullDataLoss - FullDataLoss option will drop all the replicas which
         means that all the data will be lost.
         . Possible values include: 'Invalid', 'PartialDataLoss',
         'FullDataLoss'
        :type data_loss_mode: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartDataLoss'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        query_parameters['DataLossMode'] = self._serialize.query("data_loss_mode", data_loss_mode, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_data_loss_progress(
            self, service_id, partition_id, operation_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the progress of a partition data loss operation started using the
        StartDataLoss API.

        Gets the progress of a data loss operation started with StartDataLoss,
        using the OperationId.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionDataLossProgress
         <azure.servicefabric.models.PartitionDataLossProgress>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetDataLossProgress'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionDataLossProgress', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def start_quorum_loss(
            self, service_id, partition_id, operation_id, quorum_loss_mode, quorum_loss_duration, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Induces quorum loss for a given stateful service partition.

        Induces quorum loss for a given stateful service partition.  This API
        is useful for a temporary quorum loss situation on your service.
        Call the GetQuorumLossProgress API with the same OperationId to return
        information on the operation started with this API.
        This can only be called on stateful persisted
        (HasPersistedState==true) services.  Do not use this API on stateless
        services or stateful in-memory only services.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param quorum_loss_mode: This enum is passed to the StartQuorumLoss
         API to indicate what type of quorum loss to induce.
         - Invalid - Reserved.  Do not pass into API.
         - QuorumReplicas - Partial Quorum loss mode : Minimum number of
         replicas for a partition will be down that will cause a quorum loss.
         - AllReplicas- Full Quorum loss mode : All replicas for a partition
         will be down that will cause a quorum loss.
         . Possible values include: 'Invalid', 'QuorumReplicas', 'AllReplicas'
        :type quorum_loss_mode: str
        :param quorum_loss_duration: The amount of time for which the
         partition will be kept in quorum loss.  This must be specified in
         seconds.
        :type quorum_loss_duration: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartQuorumLoss'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        query_parameters['QuorumLossMode'] = self._serialize.query("quorum_loss_mode", quorum_loss_mode, 'str')
        query_parameters['QuorumLossDuration'] = self._serialize.query("quorum_loss_duration", quorum_loss_duration, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_quorum_loss_progress(
            self, service_id, partition_id, operation_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the progress of a quorum loss operation on a partition started
        using the StartQuorumLoss API.

        Gets the progress of a quorum loss operation started with
        StartQuorumLoss, using the provided OperationId.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionQuorumLossProgress
         <azure.servicefabric.models.PartitionQuorumLossProgress>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetQuorumLossProgress'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionQuorumLossProgress', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def start_partition_restart(
            self, service_id, partition_id, operation_id, restart_partition_mode, timeout=60, custom_headers=None, raw=False, **operation_config):
        """This API will restart some or all replicas or instances of the
        specified partition.

        This API is useful for testing failover.
        If used to target a stateless service partition, RestartPartitionMode
        must be AllReplicasOrInstances.
        Call the GetPartitionRestartProgress API using the same OperationId to
        get the progress.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param restart_partition_mode: - Invalid - Reserved.  Do not pass
         into API.
         - AllReplicasOrInstances - All replicas or instances in the partition
         are restarted at once.
         - OnlyActiveSecondaries - Only the secondary replicas are restarted.
         . Possible values include: 'Invalid', 'AllReplicasOrInstances',
         'OnlyActiveSecondaries'
        :type restart_partition_mode: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartRestart'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        query_parameters['RestartPartitionMode'] = self._serialize.query("restart_partition_mode", restart_partition_mode, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_partition_restart_progress(
            self, service_id, partition_id, operation_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the progress of a PartitionRestart operation started using
        StartPartitionRestart.

        Gets the progress of a PartitionRestart started with
        StartPartitionRestart using the provided OperationId.
        .

        :param service_id: The identity of the service. This is typically the
         full name of the service without the 'fabric:' URI scheme.
        :type service_id: str
        :param partition_id: The identity of the partition.
        :type partition_id: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PartitionRestartProgress
         <azure.servicefabric.models.PartitionRestartProgress>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetRestartProgress'
        path_format_arguments = {
            'serviceId': self._serialize.url("service_id", service_id, 'str', skip_quote=True),
            'partitionId': self._serialize.url("partition_id", partition_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PartitionRestartProgress', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def start_node_transition(
            self, node_name, operation_id, node_transition_type, node_instance_id, stop_duration_in_seconds, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Starts or stops a cluster node.

        Starts or stops a cluster node.  A cluster node is a process, not the
        OS instance itself.  To start a node, pass in "Start" for the
        NodeTransitionType parameter.
        To stop a node, pass in "Stop" for the NodeTransitionType parameter.
        This API starts the operation - when the API returns the node may
        not have finished transitioning yet.
        Call GetNodeTransitionProgress with the same OperationId to get the
        progress of the operation.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param node_transition_type: Indicates the type of transition to
         perform.  NodeTransitionType.Start will start a stopped node.
         NodeTransitionType.Stop will stop a node that is up.
         - Invalid - Reserved.  Do not pass into API.
         - Start - Transition a stopped node to up.
         - Stop - Transition an up node to stopped.
         . Possible values include: 'Invalid', 'Start', 'Stop'
        :type node_transition_type: str
        :param node_instance_id: The node instance ID of the target node.
         This can be determined through GetNodeInfo API.
        :type node_instance_id: str
        :param stop_duration_in_seconds: The duration, in seconds, to keep
         the node stopped.  The minimum value is 600, the maximum is 14400.
         After this time expires, the node will automatically come back up.
        :type stop_duration_in_seconds: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Nodes/{nodeName}/$/StartTransition/'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        query_parameters['NodeTransitionType'] = self._serialize.query("node_transition_type", node_transition_type, 'str')
        query_parameters['NodeInstanceId'] = self._serialize.query("node_instance_id", node_instance_id, 'str')
        query_parameters['StopDurationInSeconds'] = self._serialize.query("stop_duration_in_seconds", stop_duration_in_seconds, 'int', minimum=0)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_node_transition_progress(
            self, node_name, operation_id, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets the progress of an operation started using StartNodeTransition.

        Gets the progress of an operation started with StartNodeTransition
        using the provided OperationId.
        .

        :param node_name: The name of the node.
        :type node_name: str
        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`NodeTransitionProgress
         <azure.servicefabric.models.NodeTransitionProgress>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/Nodes/{nodeName}/$/GetTransitionProgress'
        path_format_arguments = {
            'nodeName': self._serialize.url("node_name", node_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeTransitionProgress', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_fault_operation_list(
            self, type_filter=65535, state_filter=65535, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Gets a list of user-induced fault operations filtered by provided
        input.

        Gets the a list of user-induced fault operations filtered by provided
        input.

        :param type_filter: Used to filter on OperationType for user-induced
         operations.
         65535 - select all
         1     - select PartitionDataLoss.
         2     - select PartitionQuorumLoss.
         4     - select PartitionRestart.
         8     - select NodeTransition.
        :type type_filter: int
        :param state_filter: Used to filter on OperationState's for
         user-induced operations.
         65535 - select All
         1     - select Running
         2     - select RollingBack
         8     - select Completed
         16    - select Faulted
         32    - select Cancelled
         64    - select ForceCancelled
        :type state_filter: int
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: list of :class:`OperationStatus
         <azure.servicefabric.models.OperationStatus>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['TypeFilter'] = self._serialize.query("type_filter", type_filter, 'int')
        query_parameters['StateFilter'] = self._serialize.query("state_filter", state_filter, 'int')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[OperationStatus]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def cancel_operation(
            self, operation_id, force=False, timeout=60, custom_headers=None, raw=False, **operation_config):
        """Cancels a user-induced fault operation.

        The following is a list of APIs that start fault operations that may
        be cancelled using CancelOperation -
        - StartDataLoss
        - StartQuorumLoss
        - StartPartitionRestart
        - StartNodeTransition
        If force is false, then the specified user-induced operation will be
        gracefully stopped and cleaned up.  If force is true, the command
        will be aborted, and some internal state
        may be left behind.  Specifying force as true should be used with
        care.  Calling this API with force set to true is not allowed until
        this API has already
        been called on the same test command with force set to false first, or
        unless the test command already has an OperationState of
        OperationState.RollingBack.
        Clarification: OperationState.RollingBack means that the system
        will/is be cleaning up internal system state caused by executing the
        command.  It will not restore data if the
        test command was to cause data loss.  For example, if you call
        StartDataLoss then call this API, the system will only clean up
        internal state from running the command.
        It will not restore the target partition's data, if the command
        progressed far enough to cause data loss.
        Important note:  if this API is invoked with force==true, internal
        state may be left behind.
        .

        :param operation_id: A GUID that identifies a call of this API.  This
         is passed into the corresponding GetProgress API
        :type operation_id: str
        :param force: Indicates whether to gracefully rollback and clean up
         internal system state modified by executing the user-induced
         operation.
        :type force: bool
        :param timeout: The server timeout for performing the operation in
         seconds. This specifies the time duration that the client is willing
         to wait for the requested operation to complete. The default value
         for this parameter is 60 seconds.
        :type timeout: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`FabricErrorException<azure.servicefabric.models.FabricErrorException>`
        """
        api_version = "3.0"

        # Construct URL
        url = '/Faults/$/Cancel'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['OperationId'] = self._serialize.query("operation_id", operation_id, 'str')
        query_parameters['Force'] = self._serialize.query("force", force, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'long', maximum=4294967295, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.FabricErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
