# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ComplianceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The compliance state that should be set on the resource.
    """

    #: The resource is in compliance with the policy.
    COMPLIANT = "Compliant"
    #: The resource is not in compliance with the policy.
    NON_COMPLIANT = "NonCompliant"
    #: The compliance state of the resource is not known.
    UNKNOWN = "Unknown"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class FieldRestrictionResult(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of restriction that is imposed on the field.
    """

    #: The field and/or values are required by policy.
    REQUIRED = "Required"
    #: The field will be removed by policy.
    REMOVED = "Removed"
    #: The field and/or values will be denied by policy.
    DENY = "Deny"

class PolicyStatesResource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"
    LATEST = "latest"

class ResourceDiscoveryMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not
    specified.
    """

    #: Remediate resources that are already known to be non-compliant.
    EXISTING_NON_COMPLIANT = "ExistingNonCompliant"
    #: Re-evaluate the compliance state of resources and then remediate the resources found to be
    #: non-compliant.
    RE_EVALUATE_COMPLIANCE = "ReEvaluateCompliance"
