# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AlertRuleResource(Resource):  # pylint: disable=too-many-instance-attributes
    """The alert rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar name_properties_name: the name of the alert rule. Required.
    :vartype name_properties_name: str
    :ivar description: the description of the alert rule that will be included in the alert email.
    :vartype description: str
    :ivar provisioning_state: the provisioning state.
    :vartype provisioning_state: str
    :ivar is_enabled: the flag that indicates whether the alert rule is enabled. Required.
    :vartype is_enabled: bool
    :ivar condition: the condition that results in the alert rule being activated. Required.
    :vartype condition: ~azure.mgmt.monitor.v2015_07_01.models.RuleCondition
    :ivar action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :vartype action: ~azure.mgmt.monitor.v2015_07_01.models.RuleAction
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~azure.mgmt.monitor.v2015_07_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "name_properties_name": {"required": True},
        "is_enabled": {"required": True},
        "condition": {"required": True},
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "condition": {"key": "properties.condition", "type": "RuleCondition"},
        "action": {"key": "properties.action", "type": "RuleAction"},
        "actions": {"key": "properties.actions", "type": "[RuleAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        name_properties_name: str,
        is_enabled: bool,
        condition: "_models.RuleCondition",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        action: Optional["_models.RuleAction"] = None,
        actions: Optional[List["_models.RuleAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name_properties_name: the name of the alert rule. Required.
        :paramtype name_properties_name: str
        :keyword description: the description of the alert rule that will be included in the alert
         email.
        :paramtype description: str
        :keyword provisioning_state: the provisioning state.
        :paramtype provisioning_state: str
        :keyword is_enabled: the flag that indicates whether the alert rule is enabled. Required.
        :paramtype is_enabled: bool
        :keyword condition: the condition that results in the alert rule being activated. Required.
        :paramtype condition: ~azure.mgmt.monitor.v2015_07_01.models.RuleCondition
        :keyword action: action that is performed when the alert rule becomes active, and when an alert
         condition is resolved.
        :paramtype action: ~azure.mgmt.monitor.v2015_07_01.models.RuleAction
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~azure.mgmt.monitor.v2015_07_01.models.RuleAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.name_properties_name = name_properties_name
        self.description = description
        self.provisioning_state = provisioning_state
        self.is_enabled = is_enabled
        self.condition = condition
        self.action = action
        self.actions = actions
        self.last_updated_time = None


class AlertRuleResourceCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: the values for the alert rule resources.
    :vartype value: list[~azure.mgmt.monitor.v2015_07_01.models.AlertRuleResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertRuleResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.AlertRuleResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: the values for the alert rule resources.
        :paramtype value: list[~azure.mgmt.monitor.v2015_07_01.models.AlertRuleResource]
        """
        super().__init__(**kwargs)
        self.value = value


class AlertRuleResourcePatch(_serialization.Model):
    """The alert rule object for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar name: the name of the alert rule.
    :vartype name: str
    :ivar description: the description of the alert rule that will be included in the alert email.
    :vartype description: str
    :ivar provisioning_state: the provisioning state.
    :vartype provisioning_state: str
    :ivar is_enabled: the flag that indicates whether the alert rule is enabled.
    :vartype is_enabled: bool
    :ivar condition: the condition that results in the alert rule being activated.
    :vartype condition: ~azure.mgmt.monitor.v2015_07_01.models.RuleCondition
    :ivar action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :vartype action: ~azure.mgmt.monitor.v2015_07_01.models.RuleAction
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~azure.mgmt.monitor.v2015_07_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "name": {"key": "properties.name", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "condition": {"key": "properties.condition", "type": "RuleCondition"},
        "action": {"key": "properties.action", "type": "RuleAction"},
        "actions": {"key": "properties.actions", "type": "[RuleAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        condition: Optional["_models.RuleCondition"] = None,
        action: Optional["_models.RuleAction"] = None,
        actions: Optional[List["_models.RuleAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name: the name of the alert rule.
        :paramtype name: str
        :keyword description: the description of the alert rule that will be included in the alert
         email.
        :paramtype description: str
        :keyword provisioning_state: the provisioning state.
        :paramtype provisioning_state: str
        :keyword is_enabled: the flag that indicates whether the alert rule is enabled.
        :paramtype is_enabled: bool
        :keyword condition: the condition that results in the alert rule being activated.
        :paramtype condition: ~azure.mgmt.monitor.v2015_07_01.models.RuleCondition
        :keyword action: action that is performed when the alert rule becomes active, and when an alert
         condition is resolved.
        :paramtype action: ~azure.mgmt.monitor.v2015_07_01.models.RuleAction
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~azure.mgmt.monitor.v2015_07_01.models.RuleAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.name = name
        self.description = description
        self.provisioning_state = provisioning_state
        self.is_enabled = is_enabled
        self.condition = condition
        self.action = action
        self.actions = actions
        self.last_updated_time = None


class DimensionProperties(_serialization.Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Legacy usage, should not set.
    :vartype to_be_exported_for_shoebox: bool
    :ivar is_hidden: When set, the dimension is hidden from the customer, used in conjunction with
     the defaultDimensionValues field below.
    :vartype is_hidden: bool
    :ivar default_dimension_values: Default dimension value to be sent down for the hidden
     dimension during query.
    :vartype default_dimension_values: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
        "is_hidden": {"key": "isHidden", "type": "bool"},
        "default_dimension_values": {"key": "defaultDimensionValues", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        is_hidden: Optional[bool] = None,
        default_dimension_values: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: Legacy usage, should not set.
        :paramtype to_be_exported_for_shoebox: bool
        :keyword is_hidden: When set, the dimension is hidden from the customer, used in conjunction
         with the defaultDimensionValues field below.
        :paramtype is_hidden: bool
        :keyword default_dimension_values: Default dimension value to be sent down for the hidden
         dimension during query.
        :paramtype default_dimension_values: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox
        self.is_hidden = is_hidden
        self.default_dimension_values = default_dimension_values


class ErrorContract(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.v2015_07_01.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.v2015_07_01.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(_serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: the invariant value. Required.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: str, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: the invariant value. Required.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class RuleCondition(_serialization.Model):
    """The condition that results in the alert rule being activated.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LocationThresholdRuleCondition, ManagementEventRuleCondition, ThresholdRuleCondition

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric). Required.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "data_source": {"key": "dataSource", "type": "RuleDataSource"},
    }

    _subtype_map = {
        "odata_type": {
            "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition": "LocationThresholdRuleCondition",
            "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition": "ManagementEventRuleCondition",
            "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition": "ThresholdRuleCondition",
        }
    }

    def __init__(self, *, data_source: Optional["_models.RuleDataSource"] = None, **kwargs: Any) -> None:
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
        """
        super().__init__(**kwargs)
        self.odata_type: Optional[str] = None
        self.data_source = data_source


class LocationThresholdRuleCondition(RuleCondition):
    """A rule condition based on a certain number of locations failing.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric). Required.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    :ivar failed_location_count: the number of locations that must fail to activate the alert.
     Required.
    :vartype failed_location_count: int
    """

    _validation = {
        "odata_type": {"required": True},
        "failed_location_count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "data_source": {"key": "dataSource", "type": "RuleDataSource"},
        "window_size": {"key": "windowSize", "type": "duration"},
        "failed_location_count": {"key": "failedLocationCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        failed_location_count: int,
        data_source: Optional["_models.RuleDataSource"] = None,
        window_size: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        :keyword failed_location_count: the number of locations that must fail to activate the alert.
         Required.
        :paramtype failed_location_count: int
        """
        super().__init__(data_source=data_source, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
        self.window_size = window_size
        self.failed_location_count = failed_location_count


class LogSettings(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :vartype category: str
    :ivar enabled: a value indicating whether this log is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this log.
    :vartype retention_policy: ~azure.mgmt.monitor.v2015_07_01.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        category: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Name of a Diagnostic Log category for a resource type this setting is
         applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
         diagnostic settings operation.
        :paramtype category: str
        :keyword enabled: a value indicating whether this log is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this log.
        :paramtype retention_policy: ~azure.mgmt.monitor.v2015_07_01.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.category = category
        self.enabled = enabled
        self.retention_policy = retention_policy


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagementEventAggregationCondition(_serialization.Model):
    """How the data that is collected should be combined over time.

    :ivar operator: the condition operator. Known values are: "GreaterThan", "GreaterThanOrEqual",
     "LessThan", and "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.v2015_07_01.models.ConditionOperator
    :ivar threshold: The threshold value that activates the alert.
    :vartype threshold: float
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    """

    _attribute_map = {
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
        "window_size": {"key": "windowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        operator: Optional[Union[str, "_models.ConditionOperator"]] = None,
        threshold: Optional[float] = None,
        window_size: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operator: the condition operator. Known values are: "GreaterThan",
         "GreaterThanOrEqual", "LessThan", and "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.v2015_07_01.models.ConditionOperator
        :keyword threshold: The threshold value that activates the alert.
        :paramtype threshold: float
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size


class ManagementEventRuleCondition(RuleCondition):
    """A management event rule condition.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric). Required.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
    :ivar aggregation: How the data that is collected should be combined over time and when the
     alert is activated. Note that for management event alerts aggregation is optional – if it is
     not provided then any event will cause the alert to activate.
    :vartype aggregation:
     ~azure.mgmt.monitor.v2015_07_01.models.ManagementEventAggregationCondition
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "data_source": {"key": "dataSource", "type": "RuleDataSource"},
        "aggregation": {"key": "aggregation", "type": "ManagementEventAggregationCondition"},
    }

    def __init__(
        self,
        *,
        data_source: Optional["_models.RuleDataSource"] = None,
        aggregation: Optional["_models.ManagementEventAggregationCondition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
        :keyword aggregation: How the data that is collected should be combined over time and when the
         alert is activated. Note that for management event alerts aggregation is optional – if it is
         not provided then any event will cause the alert to activate.
        :paramtype aggregation:
         ~azure.mgmt.monitor.v2015_07_01.models.ManagementEventAggregationCondition
        """
        super().__init__(data_source=data_source, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
        self.aggregation = aggregation


class MetricAvailability(_serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the
    retention period for that time grain.

    :ivar time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :vartype time_grain: ~datetime.timedelta
    :ivar retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :vartype retention: ~datetime.timedelta
    :ivar location: Info about where the metric data is stored.
    :vartype location: ~azure.mgmt.monitor.v2015_07_01.models.MetricAvailabilityLocation
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "retention": {"key": "retention", "type": "duration"},
        "location": {"key": "location", "type": "MetricAvailabilityLocation"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        location: Optional["_models.MetricAvailabilityLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: the time grain specifies the aggregation interval for the metric.
         Expressed as a duration 'PT1M', 'P1D', etc.
        :paramtype time_grain: ~datetime.timedelta
        :keyword retention: the retention period for the metric at the specified timegrain.  Expressed
         as a duration 'PT1M', 'P1D', etc.
        :paramtype retention: ~datetime.timedelta
        :keyword location: Info about where the metric data is stored.
        :paramtype location: ~azure.mgmt.monitor.v2015_07_01.models.MetricAvailabilityLocation
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.location = location


class MetricAvailabilityLocation(_serialization.Model):
    """Info about where the metric data is stored.

    :ivar table_endpoint: The url for the storage account.
    :vartype table_endpoint: str
    :ivar table_info: Info about the storage tables storing this resources metrics.
    :vartype table_info: list[~azure.mgmt.monitor.v2015_07_01.models.TableInfoEntry]
    :ivar partition_key: partition key in the table where the metrics for this resource are stored.
    :vartype partition_key: str
    """

    _attribute_map = {
        "table_endpoint": {"key": "tableEndpoint", "type": "str"},
        "table_info": {"key": "tableInfo", "type": "[TableInfoEntry]"},
        "partition_key": {"key": "partitionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        table_endpoint: Optional[str] = None,
        table_info: Optional[List["_models.TableInfoEntry"]] = None,
        partition_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_endpoint: The url for the storage account.
        :paramtype table_endpoint: str
        :keyword table_info: Info about the storage tables storing this resources metrics.
        :paramtype table_info: list[~azure.mgmt.monitor.v2015_07_01.models.TableInfoEntry]
        :keyword partition_key: partition key in the table where the metrics for this resource are
         stored.
        :paramtype partition_key: str
        """
        super().__init__(**kwargs)
        self.table_endpoint = table_endpoint
        self.table_info = table_info
        self.partition_key = partition_key


class MetricDefinition(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric definition class specifies the metadata for a metric.

    :ivar resource_id: The resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar resource_uri: The resource identifier of the resource that emitted the metric.
    :vartype resource_uri: str
    :ivar name: the name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~azure.mgmt.monitor.v2015_07_01.models.LocalizableString
    :ivar category: The category of this metric.
    :vartype category: str
    :ivar unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", and "MilliSeconds".
    :vartype unit: str or ~azure.mgmt.monitor.v2015_07_01.models.Unit
    :ivar start_time: Start time of the metadata request timespan.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the metadata request timespan.
    :vartype end_time: ~datetime.datetime
    :ivar primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
     "Total".
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.monitor.v2015_07_01.models.AggregationType
    :ivar supported_aggregation_types: List of all aggregations that are applicable for this
     metric.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.monitor.v2015_07_01.models.AggregationType]
    :ivar metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities: list[~azure.mgmt.monitor.v2015_07_01.models.MetricAvailability]
    :ivar id: the resource identifier of the metric definition.
    :vartype id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "name": {"key": "name", "type": "LocalizableString"},
        "category": {"key": "category", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "primary_aggregation_type": {"key": "primaryAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "metric_availabilities": {"key": "metricAvailabilities", "type": "[MetricAvailability]"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        resource_uri: Optional[str] = None,
        name: Optional["_models.LocalizableString"] = None,
        category: Optional[str] = None,
        unit: Optional[Union[str, "_models.Unit"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        primary_aggregation_type: Optional[Union[str, "_models.AggregationType"]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.AggregationType"]]] = None,
        metric_availabilities: Optional[List["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword resource_uri: The resource identifier of the resource that emitted the metric.
        :paramtype resource_uri: str
        :keyword name: the name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~azure.mgmt.monitor.v2015_07_01.models.LocalizableString
        :keyword category: The category of this metric.
        :paramtype category: str
        :keyword unit: the unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", and "MilliSeconds".
        :paramtype unit: str or ~azure.mgmt.monitor.v2015_07_01.models.Unit
        :keyword start_time: Start time of the metadata request timespan.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the metadata request timespan.
        :paramtype end_time: ~datetime.datetime
        :keyword primary_aggregation_type: the primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum", and
         "Total".
        :paramtype primary_aggregation_type: str or
         ~azure.mgmt.monitor.v2015_07_01.models.AggregationType
        :keyword supported_aggregation_types: List of all aggregations that are applicable for this
         metric.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.monitor.v2015_07_01.models.AggregationType]
        :keyword metric_availabilities: the collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities:
         list[~azure.mgmt.monitor.v2015_07_01.models.MetricAvailability]
        :keyword id: the resource identifier of the metric definition.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.resource_uri = resource_uri
        self.name = name
        self.category = category
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id


class MetricDefinitionCollection(_serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id for these metric definitions.
    :vartype id: str
    :ivar value: the values for the metric definitions. Required.
    :vartype value: list[~azure.mgmt.monitor.v2015_07_01.models.MetricDefinition]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "value": {"key": "value", "type": "[MetricDefinition]"},
    }

    def __init__(
        self,
        *,
        value: List["_models.MetricDefinition"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id for these metric definitions.
        :paramtype id: str
        :keyword value: the values for the metric definitions. Required.
        :paramtype value: list[~azure.mgmt.monitor.v2015_07_01.models.MetricDefinition]
        """
        super().__init__(**kwargs)
        self.id = id
        self.value = value


class MetricSettings(_serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to Azure.

    :ivar time_grain: the timegrain of the metric in ISO8601 format. Required.
    :vartype time_grain: ~datetime.timedelta
    :ivar enabled: a value indicating whether this timegrain is enabled. Required.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this timegrain.
    :vartype retention_policy: ~azure.mgmt.monitor.v2015_07_01.models.RetentionPolicy
    """

    _validation = {
        "time_grain": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "duration"},
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        time_grain: datetime.timedelta,
        enabled: bool,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: the timegrain of the metric in ISO8601 format. Required.
        :paramtype time_grain: ~datetime.timedelta
        :keyword enabled: a value indicating whether this timegrain is enabled. Required.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this timegrain.
        :paramtype retention_policy: ~azure.mgmt.monitor.v2015_07_01.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric specification of operation.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: Display name of the metric.
    :vartype display_name: str
    :ivar display_description: Display description of the metric.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include:
     Count,Bytes,Seconds,Percent,CountPerSecond,BytesPerSecond,MilliSeconds,ByteSeconds,Unspecified,BitsPerSecond,Cores,MilliCores,NanoCores.
    :vartype unit: str
    :ivar aggregation_type: The default metric aggregation type. Possible values include:
     Total,Average,Maximum,Minimum,Count.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: The supported aggregation types for the metrics.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar availabilities: The supported time grain types for the metrics.
    :vartype availabilities: list[str]
    :ivar lock_aggregation_type: The metric lock aggregation type.
    :vartype lock_aggregation_type: str
    :ivar category: Category or type of metric.
    :vartype category: str
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.monitor.v2015_07_01.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill empty gaps with zero.
    :vartype fill_gap_with_zero: bool
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "availabilities": {"key": "availabilities", "type": "[str]"},
        "lock_aggregation_type": {"key": "lockAggregationType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[DimensionProperties]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        availabilities: Optional[List[str]] = None,
        lock_aggregation_type: Optional[str] = None,
        category: Optional[str] = None,
        dimensions: Optional[List["_models.DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the metric.
        :paramtype name: str
        :keyword display_name: Display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Display description of the metric.
        :paramtype display_description: str
        :keyword unit: The metric unit. Possible values include:
         Count,Bytes,Seconds,Percent,CountPerSecond,BytesPerSecond,MilliSeconds,ByteSeconds,Unspecified,BitsPerSecond,Cores,MilliCores,NanoCores.
        :paramtype unit: str
        :keyword aggregation_type: The default metric aggregation type. Possible values include:
         Total,Average,Maximum,Minimum,Count.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: The supported aggregation types for the metrics.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword availabilities: The supported time grain types for the metrics.
        :paramtype availabilities: list[str]
        :keyword lock_aggregation_type: The metric lock aggregation type.
        :paramtype lock_aggregation_type: str
        :keyword category: Category or type of metric.
        :paramtype category: str
        :keyword dimensions: The dimensions of metric.
        :paramtype dimensions: list[~azure.mgmt.monitor.v2015_07_01.models.DimensionProperties]
        :keyword fill_gap_with_zero: Property to specify whether to fill empty gaps with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword internal_metric_name: The internal metric name.
        :paramtype internal_metric_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.availabilities = availabilities
        self.lock_aggregation_type = lock_aggregation_type
        self.category = category
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.internal_metric_name = internal_metric_name


class Operation(_serialization.Model):
    """Microsoft Insights API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Property to specify whether the action is a data action.
    :vartype is_data_action: bool
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.monitor.v2015_07_01.models.OperationDisplay
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.monitor.v2015_07_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Property to specify whether the action is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.monitor.v2015_07_01.models.OperationDisplay
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.monitor.v2015_07_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar publisher: The publisher of this operation.
    :vartype publisher: str
    :ivar provider: Service provider: Microsoft.Insights.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The publisher of this operation.
        :paramtype publisher: str
        :keyword provider: Service provider: Microsoft.Insights.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: The description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Microsoft.Insights provider.
    :vartype value: list[~azure.mgmt.monitor.v2015_07_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Microsoft.Insights provider.
        :paramtype value: list[~azure.mgmt.monitor.v2015_07_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RetentionPolicy(_serialization.Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: a value indicating whether the retention policy is enabled. Required.
    :vartype enabled: bool
    :ivar days: the number of days for the retention in days. A value of 0 will retain the events
     indefinitely. Required.
    :vartype days: int
    """

    _validation = {
        "enabled": {"required": True},
        "days": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "days": {"key": "days", "type": "int"},
    }

    def __init__(self, *, enabled: bool, days: int, **kwargs: Any) -> None:
        """
        :keyword enabled: a value indicating whether the retention policy is enabled. Required.
        :paramtype enabled: bool
        :keyword days: the number of days for the retention in days. A value of 0 will retain the
         events indefinitely. Required.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class RuleAction(_serialization.Model):
    """The action that is performed when the alert rule becomes active, and when an alert condition is
    resolved.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RuleEmailAction, RuleWebhookAction

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "Microsoft.Azure.Management.Insights.Models.RuleEmailAction": "RuleEmailAction",
            "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction": "RuleWebhookAction",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.odata_type: Optional[str] = None


class RuleDataSource(_serialization.Model):
    """The resource from which the rule collects its data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RuleManagementEventDataSource, RuleMetricDataSource

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of data source. There are two types of rule data sources:
     RuleMetricDataSource and RuleManagementEventDataSource. Required.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "legacy_resource_id": {"key": "legacyResourceId", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource": "RuleManagementEventDataSource",
            "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource": "RuleMetricDataSource",
        }
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        """
        super().__init__(**kwargs)
        self.odata_type: Optional[str] = None
        self.resource_uri = resource_uri
        self.legacy_resource_id = legacy_resource_id
        self.resource_location = resource_location
        self.metric_namespace = metric_namespace


class RuleEmailAction(RuleAction):
    """Specifies the action to send email when the rule condition is evaluated. The discriminator is
    always RuleEmailAction in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction. Required.
    :vartype odata_type: str
    :ivar send_to_service_owners: Whether the administrators (service and co-administrators) of the
     service should be notified when the alert is activated.
    :vartype send_to_service_owners: bool
    :ivar custom_emails: the list of administrator's custom email addresses to notify of the
     activation of the alert.
    :vartype custom_emails: list[str]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "send_to_service_owners": {"key": "sendToServiceOwners", "type": "bool"},
        "custom_emails": {"key": "customEmails", "type": "[str]"},
    }

    def __init__(
        self, *, send_to_service_owners: Optional[bool] = None, custom_emails: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword send_to_service_owners: Whether the administrators (service and co-administrators) of
         the service should be notified when the alert is activated.
        :paramtype send_to_service_owners: bool
        :keyword custom_emails: the list of administrator's custom email addresses to notify of the
         activation of the alert.
        :paramtype custom_emails: list[str]
        """
        super().__init__(**kwargs)
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
        self.send_to_service_owners = send_to_service_owners
        self.custom_emails = custom_emails


class RuleManagementEventClaimsDataSource(_serialization.Model):
    """The claims for a rule management event data source.

    :ivar email_address: the email address.
    :vartype email_address: str
    """

    _attribute_map = {
        "email_address": {"key": "emailAddress", "type": "str"},
    }

    def __init__(self, *, email_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword email_address: the email address.
        :paramtype email_address: str
        """
        super().__init__(**kwargs)
        self.email_address = email_address


class RuleManagementEventDataSource(RuleDataSource):  # pylint: disable=too-many-instance-attributes
    """A rule management event data source. The discriminator fields is always
    RuleManagementEventDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of data source. There are two types of rule data sources:
     RuleMetricDataSource and RuleManagementEventDataSource. Required.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    :ivar event_name: the event name.
    :vartype event_name: str
    :ivar event_source: the event source.
    :vartype event_source: str
    :ivar level: the level.
    :vartype level: str
    :ivar operation_name: The name of the operation that should be checked for. If no name is
     provided, any operation will match.
    :vartype operation_name: str
    :ivar resource_group_name: the resource group name.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name.
    :vartype resource_provider_name: str
    :ivar status: The status of the operation that should be checked for. If no status is provided,
     any status will match.
    :vartype status: str
    :ivar sub_status: the substatus.
    :vartype sub_status: str
    :ivar claims: the claims.
    :vartype claims: ~azure.mgmt.monitor.v2015_07_01.models.RuleManagementEventClaimsDataSource
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "legacy_resource_id": {"key": "legacyResourceId", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "event_name": {"key": "eventName", "type": "str"},
        "event_source": {"key": "eventSource", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "operation_name": {"key": "operationName", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "resource_provider_name": {"key": "resourceProviderName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "sub_status": {"key": "subStatus", "type": "str"},
        "claims": {"key": "claims", "type": "RuleManagementEventClaimsDataSource"},
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        event_name: Optional[str] = None,
        event_source: Optional[str] = None,
        level: Optional[str] = None,
        operation_name: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        resource_provider_name: Optional[str] = None,
        status: Optional[str] = None,
        sub_status: Optional[str] = None,
        claims: Optional["_models.RuleManagementEventClaimsDataSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        :keyword event_name: the event name.
        :paramtype event_name: str
        :keyword event_source: the event source.
        :paramtype event_source: str
        :keyword level: the level.
        :paramtype level: str
        :keyword operation_name: The name of the operation that should be checked for. If no name is
         provided, any operation will match.
        :paramtype operation_name: str
        :keyword resource_group_name: the resource group name.
        :paramtype resource_group_name: str
        :keyword resource_provider_name: the resource provider name.
        :paramtype resource_provider_name: str
        :keyword status: The status of the operation that should be checked for. If no status is
         provided, any status will match.
        :paramtype status: str
        :keyword sub_status: the substatus.
        :paramtype sub_status: str
        :keyword claims: the claims.
        :paramtype claims: ~azure.mgmt.monitor.v2015_07_01.models.RuleManagementEventClaimsDataSource
        """
        super().__init__(
            resource_uri=resource_uri,
            legacy_resource_id=legacy_resource_id,
            resource_location=resource_location,
            metric_namespace=metric_namespace,
            **kwargs
        )
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
        self.event_name = event_name
        self.event_source = event_source
        self.level = level
        self.operation_name = operation_name
        self.resource_group_name = resource_group_name
        self.resource_provider_name = resource_provider_name
        self.status = status
        self.sub_status = sub_status
        self.claims = claims


class RuleMetricDataSource(RuleDataSource):
    """A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of data source. There are two types of rule data sources:
     RuleMetricDataSource and RuleManagementEventDataSource. Required.
    :vartype odata_type: str
    :ivar resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ : this
     property cannot be updated for an existing rule.
    :vartype resource_uri: str
    :ivar legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :vartype legacy_resource_id: str
    :ivar resource_location: the location of the resource.
    :vartype resource_location: str
    :ivar metric_namespace: the namespace of the metric.
    :vartype metric_namespace: str
    :ivar metric_name: the name of the metric that defines what the rule monitors.
    :vartype metric_name: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "legacy_resource_id": {"key": "legacyResourceId", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_uri: Optional[str] = None,
        legacy_resource_id: Optional[str] = None,
        resource_location: Optional[str] = None,
        metric_namespace: Optional[str] = None,
        metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
         this property cannot be updated for an existing rule.
        :paramtype resource_uri: str
        :keyword legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
         **NOTE**\ : this property cannot be updated for an existing rule.
        :paramtype legacy_resource_id: str
        :keyword resource_location: the location of the resource.
        :paramtype resource_location: str
        :keyword metric_namespace: the namespace of the metric.
        :paramtype metric_namespace: str
        :keyword metric_name: the name of the metric that defines what the rule monitors.
        :paramtype metric_name: str
        """
        super().__init__(
            resource_uri=resource_uri,
            legacy_resource_id=legacy_resource_id,
            resource_location=resource_location,
            metric_namespace=metric_namespace,
            **kwargs
        )
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
        self.metric_name = metric_name


class RuleWebhookAction(RuleAction):
    """Specifies the action to post to service when the rule condition is evaluated. The discriminator
    is always RuleWebhookAction in this case.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction. Required.
    :vartype odata_type: str
    :ivar service_uri: the service uri to Post the notification when the alert activates or
     resolves.
    :vartype service_uri: str
    :ivar properties: the dictionary of custom properties to include with the post operation. These
     data are appended to the webhook payload.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "service_uri": {"key": "serviceUri", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self, *, service_uri: Optional[str] = None, properties: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_uri: the service uri to Post the notification when the alert activates or
         resolves.
        :paramtype service_uri: str
        :keyword properties: the dictionary of custom properties to include with the post operation.
         These data are appended to the webhook payload.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
        self.service_uri = service_uri
        self.properties = properties


class ServiceDiagnosticSettingsResource(Resource):
    """Description of a service diagnostic setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :vartype service_bus_rule_id: str
    :ivar metrics: the list of metric settings.
    :vartype metrics: list[~azure.mgmt.monitor.v2015_07_01.models.MetricSettings]
    :ivar logs: the list of logs settings.
    :vartype logs: list[~azure.mgmt.monitor.v2015_07_01.models.LogSettings]
    :ivar workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
     Analytics workspace to which you would like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "service_bus_rule_id": {"key": "properties.serviceBusRuleId", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "[MetricSettings]"},
        "logs": {"key": "properties.logs", "type": "[LogSettings]"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        metrics: Optional[List["_models.MetricSettings"]] = None,
        logs: Optional[List["_models.LogSettings"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
         would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
         format: '{service bus resource ID}/authorizationrules/{key name}'.
        :paramtype service_bus_rule_id: str
        :keyword metrics: the list of metric settings.
        :paramtype metrics: list[~azure.mgmt.monitor.v2015_07_01.models.MetricSettings]
        :keyword logs: the list of logs settings.
        :paramtype logs: list[~azure.mgmt.monitor.v2015_07_01.models.LogSettings]
        :keyword workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
         Analytics workspace to which you would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.metrics = metrics
        self.logs = logs
        self.workspace_id = workspace_id


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.monitor.v2015_07_01.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.monitor.v2015_07_01.models.MetricSpecification]
    :ivar legacy_metric_specifications: Legacy Metric specifications for operation. Deprecated, do
     not use.
    :vartype legacy_metric_specifications: JSON
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "legacy_metric_specifications": {"key": "legacyMetricSpecifications", "type": "object"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        legacy_metric_specifications: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.monitor.v2015_07_01.models.LogSpecification]
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.monitor.v2015_07_01.models.MetricSpecification]
        :keyword legacy_metric_specifications: Legacy Metric specifications for operation. Deprecated,
         do not use.
        :paramtype legacy_metric_specifications: JSON
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications
        self.legacy_metric_specifications = legacy_metric_specifications


class TableInfoEntry(_serialization.Model):
    """Info about a storage table with metric data.

    :ivar table_name: Name of a table with metric data for this resource.
    :vartype table_name: str
    :ivar start_time: Start time of the metrics in this table.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the metrics in this table.
    :vartype end_time: ~datetime.datetime
    :ivar sas_token: For the storage account with metrics.
    :vartype sas_token: str
    :ivar sas_token_expiration_time: For the storage account with metrics.
    :vartype sas_token_expiration_time: ~datetime.datetime
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "sas_token": {"key": "sasToken", "type": "str"},
        "sas_token_expiration_time": {"key": "sasTokenExpirationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        sas_token: Optional[str] = None,
        sas_token_expiration_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Name of a table with metric data for this resource.
        :paramtype table_name: str
        :keyword start_time: Start time of the metrics in this table.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the metrics in this table.
        :paramtype end_time: ~datetime.datetime
        :keyword sas_token: For the storage account with metrics.
        :paramtype sas_token: str
        :keyword sas_token_expiration_time: For the storage account with metrics.
        :paramtype sas_token_expiration_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.start_time = start_time
        self.end_time = end_time
        self.sas_token = sas_token
        self.sas_token_expiration_time = sas_token_expiration_time


class ThresholdRuleCondition(RuleCondition):
    """A rule condition based on a metric crossing a threshold.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric). Required.
    :vartype odata_type: str
    :ivar data_source: the resource from which the rule collects its data. For this type dataSource
     will always be of type RuleMetricDataSource.
    :vartype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
    :ivar operator: the operator used to compare the data and the threshold. Required. Known values
     are: "GreaterThan", "GreaterThanOrEqual", "LessThan", and "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.v2015_07_01.models.ConditionOperator
    :ivar threshold: the threshold value that activates the alert. Required.
    :vartype threshold: float
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :vartype window_size: ~datetime.timedelta
    :ivar time_aggregation: the time aggregation operator. How the data that are collected should
     be combined over time. The default value is the PrimaryAggregationType of the Metric. Known
     values are: "Average", "Minimum", "Maximum", "Total", and "Last".
    :vartype time_aggregation: str or
     ~azure.mgmt.monitor.v2015_07_01.models.TimeAggregationOperator
    """

    _validation = {
        "odata_type": {"required": True},
        "operator": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "data_source": {"key": "dataSource", "type": "RuleDataSource"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
        "window_size": {"key": "windowSize", "type": "duration"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
    }

    def __init__(
        self,
        *,
        operator: Union[str, "_models.ConditionOperator"],
        threshold: float,
        data_source: Optional["_models.RuleDataSource"] = None,
        window_size: Optional[datetime.timedelta] = None,
        time_aggregation: Optional[Union[str, "_models.TimeAggregationOperator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_source: the resource from which the rule collects its data. For this type
         dataSource will always be of type RuleMetricDataSource.
        :paramtype data_source: ~azure.mgmt.monitor.v2015_07_01.models.RuleDataSource
        :keyword operator: the operator used to compare the data and the threshold. Required. Known
         values are: "GreaterThan", "GreaterThanOrEqual", "LessThan", and "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.v2015_07_01.models.ConditionOperator
        :keyword threshold: the threshold value that activates the alert. Required.
        :paramtype threshold: float
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. If specified then it must be between 5 minutes and 1
         day.
        :paramtype window_size: ~datetime.timedelta
        :keyword time_aggregation: the time aggregation operator. How the data that are collected
         should be combined over time. The default value is the PrimaryAggregationType of the Metric.
         Known values are: "Average", "Minimum", "Maximum", "Total", and "Last".
        :paramtype time_aggregation: str or
         ~azure.mgmt.monitor.v2015_07_01.models.TimeAggregationOperator
        """
        super().__init__(data_source=data_source, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
        self.operator = operator
        self.threshold = threshold
        self.window_size = window_size
        self.time_aggregation = time_aggregation
