#!/bin/bash
#
# Script to run tests on Travis-CI.
#
# This file is generated by l2tdevtools update-dependencies.py, any dependency
# related changes should be made in dependencies.ini.

# Exit on error.
set -e;

if test -n "${CENTOS_VERSION}";
then
	CONTAINER_NAME="centos${CENTOS_VERSION}";
	CONTAINER_OPTIONS="-e LANG=en_US.UTF-8";

	TEST_COMMAND="./travis/run_python3.sh";

	# Note that exec options need to be defined before the container name.
	docker exec ${CONTAINER_OPTIONS} ${CONTAINER_NAME} sh -c "cd pytsk && ${TEST_COMMAND}";

elif test -n "${FEDORA_VERSION}";
then
	CONTAINER_NAME="fedora${FEDORA_VERSION}";
	CONTAINER_OPTIONS="-e LANG=en_US.UTF-8";

	TEST_COMMAND="./travis/run_python3.sh";

	# Note that exec options need to be defined before the container name.
	docker exec ${CONTAINER_OPTIONS} ${CONTAINER_NAME} sh -c "cd pytsk && ${TEST_COMMAND}";

elif test -n "${UBUNTU_VERSION}";
then
	CONTAINER_NAME="ubuntu${UBUNTU_VERSION}";
	CONTAINER_OPTIONS="-e LANG=en_US.UTF-8";

	TEST_COMMAND="./travis/run_python3.sh";

	# Note that exec options need to be defined before the container name.
	docker exec ${CONTAINER_OPTIONS} ${CONTAINER_NAME} sh -c "cd pytsk && ${TEST_COMMAND}";

elif test ${TRAVIS_OS_NAME} = "linux";
then
	python setup.py update

	python setup.py build

	PYTHONPATH=`ls -1d build/lib.*` python run_tests.py

	python setup.py sdist

	python setup.py bdist

	mkdir -p ${PWD}/tmp/lib/python${TRAVIS_PYTHON_VERSION}/site-packages/;

	PYTHONPATH=${PWD}/tmp/lib/python${TRAVIS_PYTHON_VERSION}/site-packages/ python setup.py install --prefix=${PWD}/tmp/;

elif test ${TRAVIS_OS_NAME} = "osx";
then
	./travis/run_python3.sh;
fi
