% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{estimateBetaPriorVar}
\alias{estimateBetaPriorVar}
\alias{estimateMLEForBetaPriorVar}
\title{Steps for estimating the beta prior variance}
\usage{
estimateBetaPriorVar(
  object,
  betaPriorMethod = c("weighted", "quantile"),
  upperQuantile = 0.05,
  modelMatrix = NULL
)

estimateMLEForBetaPriorVar(
  object,
  maxit = 100,
  useOptim = TRUE,
  useQR = TRUE,
  modelMatrixType = NULL
)
}
\arguments{
\item{object}{a DESeqDataSet}

\item{betaPriorMethod}{the method for calculating the beta prior variance,
either "quanitle" or "weighted":
"quantile" matches a normal distribution using the upper quantile of the finite MLE betas.
"weighted" matches a normal distribution using the upper quantile, but weighting by the variance of the MLE betas.}

\item{upperQuantile}{the upper quantile to be used for the
"quantile" or "weighted" method of beta prior variance estimation}

\item{modelMatrix}{an optional matrix, typically this is set to NULL
and created within the function}

\item{maxit}{as defined in \code{link{nbinomWaldTest}}}

\item{useOptim}{as defined in \code{link{nbinomWaldTest}}}

\item{useQR}{as defined in \code{link{nbinomWaldTest}}}

\item{modelMatrixType}{an optional override for the type which is set internally}
}
\value{
for \code{estimateMLEForBetaPriorVar}, a DESeqDataSet, with the
necessary information stored in order to calculate the prior variance.
for \code{estimateBetaPriorVar}, the vector of variances for the prior
on the betas in the \code{\link{DESeq}} GLM
}
\description{
These lower-level functions are called within \code{\link{DESeq}} or \code{\link{nbinomWaldTest}}.
End users should use those higher-level function instead.
NOTE: \code{estimateBetaPriorVar} returns a numeric vector, not a DESEqDataSet!
For advanced users: to use these functions, first run \code{estimateMLEForBetaPriorVar}
and then run \code{estimateBetaPriorVar}.
}
