% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_effects.R
\name{make_conditions}
\alias{make_conditions}
\title{Prepare Fully Crossed Conditions}
\usage{
make_conditions(x, vars, ...)
}
\arguments{
\item{x}{An \R object from which to extract the variables
that should be part of the conditions.}

\item{vars}{Names of the variables that should be part of the conditions.}

\item{...}{Arguments passed to \code{\link{rows2labels}}.}
}
\value{
A \code{data.frame} where each row indicates a condition.
}
\description{
This is a helper function to prepare fully crossed conditions primarily 
for use with the \code{conditions} argument of \code{\link{conditional_effects}}.
Automatically creates labels for each row in the \code{cond__} column.
}
\details{
For factor like variables, all levels are used as conditions.
  For numeric variables, \code{mean + (-1:1) * SD} are used as conditions.
}
\examples{
df <- data.frame(x = c("a", "b"), y = rnorm(10))
make_conditions(df, vars = c("x", "y"))

}
\seealso{
\code{\link{conditional_effects}}, \code{\link{rows2labels}}
}
