% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ac.R
\name{ar}
\alias{ar}
\title{Set up AR(p) correlation structures}
\usage{
ar(time = NA, gr = NA, p = 1, cov = FALSE)
}
\arguments{
\item{time}{An optional time variable specifying the time ordering
of the observations. By default, the existing order of the observations
in the data is used.}

\item{gr}{An optional grouping variable. If specified, the correlation
structure is assumed to apply only to observations within the same grouping
level.}

\item{p}{A non-negative integer specifying the autoregressive (AR)
order of the ARMA structure. Default is \code{1}.}

\item{cov}{A flag indicating whether ARMA effects should be estimated by
means of residual covariance matrices. This is currently only possible for
stationary ARMA effects of order 1. If the model family does not have
natural residuals, latent residuals are added automatically. If
\code{FALSE} (the default), a regression formulation is used that is
considerably faster and allows for ARMA effects of order higher than 1 but
is only available for \code{gaussian} models and some of its
generalizations.}
}
\value{
An object of class \code{'arma_term'}, which is a list
  of arguments to be interpreted by the formula
  parsing functions of \pkg{brms}.
}
\description{
Set up an autoregressive (AR) term of order p in \pkg{brms}. The function
does not evaluate its arguments -- it exists purely to help set up a model
with AR terms.
}
\examples{
\dontrun{
data("LakeHuron")
LakeHuron <- as.data.frame(LakeHuron)
fit <- brm(x ~ ar(p = 2), data = LakeHuron)
summary(fit)
}

}
\seealso{
\code{\link{autocor-terms}}, \code{\link{arma}}, \code{\link{ma}}
}
