% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survexp-tidiers.R
\name{tidy.survexp}
\alias{tidy.survexp}
\alias{sexpfit_tidiers}
\alias{survexp_tidiers}
\title{Tidy a(n) survexp object}
\usage{
\method{tidy}{survexp}(x, ...)
}
\arguments{
\item{x}{An \code{survexp} object returned from \code{\link[survival:survexp]{survival::survexp()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("survival", quietly = TRUE)) {

library(survival)
sexpfit <- survexp(
  futime ~ 1,
  rmap = list(
    sex = "male",
    year = accept.dt,
    age = (accept.dt - birth.dt)
  ),
  method = "conditional",
  data = jasa
)

tidy(sexpfit)
glance(sexpfit)

}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[survival:survexp]{survival::survexp()}}

Other survexp tidiers: 
\code{\link{glance.survexp}()}

Other survival tidiers: 
\code{\link{augment.coxph}()},
\code{\link{augment.survreg}()},
\code{\link{glance.aareg}()},
\code{\link{glance.cch}()},
\code{\link{glance.coxph}()},
\code{\link{glance.pyears}()},
\code{\link{glance.survdiff}()},
\code{\link{glance.survexp}()},
\code{\link{glance.survfit}()},
\code{\link{glance.survreg}()},
\code{\link{tidy.aareg}()},
\code{\link{tidy.cch}()},
\code{\link{tidy.coxph}()},
\code{\link{tidy.pyears}()},
\code{\link{tidy.survdiff}()},
\code{\link{tidy.survfit}()},
\code{\link{tidy.survreg}()}
}
\concept{survexp tidiers}
\concept{survival tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{n.risk}{Number of individuals at risk at time zero.}
  \item{time}{Point in time.}
  \item{estimate}{Estimate survival}

}
