% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliapp-docs.R
\name{containers}
\alias{containers}
\title{About cli containers}
\description{
Container elements may contain other elements. Currently the following
commands create container elements: \code{\link[=cli_div]{cli_div()}}, \code{\link[=cli_par]{cli_par()}}, the list
elements: \code{\link[=cli_ul]{cli_ul()}}, \code{\link[=cli_ol]{cli_ol()}}, \code{\link[=cli_dl]{cli_dl()}}, and list items are
containers as well: \code{\link[=cli_li]{cli_li()}}.
}
\details{
\subsection{Themes}{

A container can add a new theme, which is removed when the container
exits.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{d <- cli_div(theme = list(h1 = list(color = "blue",
                                    "font-weight" = "bold")))
cli_h1("Custom title")
cli_end(d)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> <span style="font-weight: bold;color: #268BD2;">Custom title</span>                                                                    
</pre></div>
}}

}

\subsection{Auto-closing}{

Container elements are closed with \code{\link[=cli_end]{cli_end()}}. For convenience,
by default they are closed automatically when the function that created
them terminated (either regularly or with an error). The default
behavior can be changed with the \code{.auto_close} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{div <- function() \{
  cli_div(class = "tmp", theme = list(.tmp = list(color = "yellow")))
  cli_text("This is yellow")
\}
div()
cli_text("This is not yellow any more")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #B58900;">This is yellow</span>                                                                  
#> This is not yellow any more                                                     
</pre></div>
}}

}

\subsection{Debugging}{

You can use the internal \code{cli:::cli_debug_doc()} function to see the
currently open containers.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_div(id = "mydiv")
  cli_par(class = "myclass")
  cli:::cli_debug_doc()
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> &lt;cli document&gt;                                                                  
#> &lt;body id="body"&gt;                                                                
#> &lt;div id="mydiv"&gt; +theme                                                         
#> &lt;par id="cli-82040-226" class="myclass"&gt;                                        
</pre></div>
}}

}
}
