% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration_spanning_seq}
\alias{duration_spanning_seq}
\title{Spanning sequence: duration}
\usage{
duration_spanning_seq(x)
}
\arguments{
\item{x}{\verb{[clock_duration]}

A duration vector.}
}
\value{
A sequence along \verb{[min(x), max(x)]}.
}
\description{
\code{duration_spanning_seq()} generates a regular sequence along the span of \code{x},
i.e. along \verb{[min(x), max(x)]}.
}
\details{
Missing values are automatically removed before the sequence is generated.

If you need more precise sequence generation, call \code{\link[=range]{range()}} and \code{\link[=seq]{seq()}}
directly.
}
\examples{
x <- duration_days(c(1, 5, 2))
duration_spanning_seq(x)

# Missing values are removed before the sequence is created
x <- vctrs::vec_c(NA, x, NA)
duration_spanning_seq(x)
}
