% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero-inflated-binomial-distribution.R
\name{ZIB}
\alias{ZIB}
\alias{dzib}
\alias{pzib}
\alias{qzib}
\alias{rzib}
\title{Zero-inflated binomial distribution}
\usage{
dzib(x, size, prob, pi, log = FALSE)

pzib(q, size, prob, pi, lower.tail = TRUE, log.p = FALSE)

qzib(p, size, prob, pi, lower.tail = TRUE, log.p = FALSE)

rzib(n, size, prob, pi)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}

\item{pi}{probability of extra zeros.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the zero-inflated binomial distribution.
}
\details{
Probability density function
\deqn{
f(x) = \left\{\begin{array}{ll}
\pi + (1 - \pi) (1-p)^n & x = 0 \\
(1 - \pi) {n \choose x} p^x (1-p)^{n-x} & x > 0 \\
\end{array}\right.
}{
f(x) = [if x = 0:] (1-\pi)+\pi * p^r [else:] (1-\pi) * dnbinom(x, size, prob)
}
}
\examples{

x <- rzib(1e5, 10, 0.6, 0.33)
xx <- -2:20
plot(prop.table(table(x)), type = "h")
lines(xx, dzib(xx, 10, 0.6, 0.33), col = "red")

xx <- seq(0, 20, by = 0.01)
plot(ecdf(x))
lines(xx, pzib(xx, 10, 0.6, 0.33), col = "red")

}
\seealso{
\code{\link[stats]{Binomial}}
}
\concept{Discrete}
\concept{Univariate}
\keyword{distribution}
