% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{as_raster}
\alias{as_raster}
\title{Transform a flextable into a raster}
\usage{
as_raster(x, ...)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments passed to other functions}
}
\description{
save a flextable as an image and return the corresponding
raster. This function has been implemented to let flextable be printed
on a ggplot object.

The function is no longer very useful since \code{\link[=gen_grob]{gen_grob()}} exists and
will be deprecated in a future version.
}
\note{
This function requires package 'magick'.
}
\examples{
ft <- qflextable(head(mtcars))
\dontrun{
if (require("ggplot2") && require("magick")) {
  print(qplot(speed, dist, data = cars, geom = "point"))
  grid::grid.raster(as_raster(ft))
}
}
}
\seealso{
Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
\keyword{internal}
