% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{set_header_labels}
\alias{set_header_labels}
\title{Change headers labels}
\usage{
set_header_labels(x, ..., values = NULL)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{named arguments (names are data colnames), each element is a single character
value specifying label to use.}

\item{values}{a named list (names are data colnames), each element is a single character
value specifying label to use. If provided, argument \code{...} will be ignored.
It can also be a unamed character vector, in that case, it must have the same
length than the number of columns of the flextable.}
}
\description{
This function set labels for specified
columns in the bottom row header of a flextable.
}
\examples{
ft <- flextable(head(iris))
ft <- set_header_labels(ft,
  Sepal.Length = "Sepal length",
  Sepal.Width = "Sepal width", Petal.Length = "Petal length",
  Petal.Width = "Petal width"
)

ft <- flextable(head(iris))
ft <- set_header_labels(ft,
  values = list(
    Sepal.Length = "Sepal length",
    Sepal.Width = "Sepal width",
    Petal.Length = "Petal length",
    Petal.Width = "Petal width"
  )
)
ft

ft <- flextable(head(iris))
ft <- set_header_labels(
  x = ft,
  values = c(
    "Sepal length",
    "Sepal width", "Petal length",
    "Petal width", "Species")
)
ft
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{delete_rows}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}}
}
\concept{functions for row and column operations in a flextable}
