% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{count_motifs}
\alias{count_motifs}
\alias{graph.motifs.no}
\title{Graph motifs}
\usage{
count_motifs(graph, size = 3, cut.prob = rep(0, size))
}
\arguments{
\item{graph}{Graph object, the input graph.}

\item{size}{The size of the motif, currently 3 and 4 are supported only.}

\item{cut.prob}{Numeric vector giving the probabilities that the search
graph is cut at a certain level. Its length should be the same as the size
of the motif (the \code{size} argument). By default no cuts are made.}
}
\value{
\code{count_motifs} returns  a numeric scalar.
}
\description{
Graph motifs are small connected subgraphs with a well-defined
structure.  These functions search a graph for various motifs.
}
\details{
\code{count_motifs} calculates the total number of motifs of a given
size in graph.
}
\examples{
g <- barabasi.game(100)
motifs(g, 3)
count_motifs(g, 3)
sample_motifs(g, 3)
}
\seealso{
\code{\link{isomorphism_class}}

Other graph motifs: 
\code{\link{motifs}()},
\code{\link{sample_motifs}()}
}
\concept{graph motifs}
