% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{handle_vertex_type_arg}
\alias{handle_vertex_type_arg}
\title{Common handler for vertex type arguments in igraph functions}
\usage{
handle_vertex_type_arg(types, graph, required = T)
}
\arguments{
\item{types}{the vertex types}

\item{graph}{the graph}

\item{required}{whether the graph has to be bipartite}
}
\value{
A logical vector representing the resolved vertex type for each
vertex in the graph
}
\description{
This function takes the \code{types} and \code{graph} arguments from a
public igraph function call and validates the vertex type vector.
}
\details{
When the provided vertex types are NULL and the graph has a \code{types}
vertex attribute, then the value of this vertex attribute will be used as
vertex types. Non-logical vertex type vectors are coerced into logical
vectors after printing a warning.
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\keyword{internal}
