% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraction_operator_linter.R
\name{extraction_operator_linter}
\alias{extraction_operator_linter}
\title{Extraction operator linter}
\usage{
extraction_operator_linter()
}
\description{
Check that the \code{[[} operator is used when extracting a single element from an object,
not \code{[} (subsetting) nor \code{$} (interactive use).
}
\details{
There are three subsetting operators in R (\code{[[}, \code{[}, and \code{$}) and they interact differently
with different data structures (atomic vector, list, data frame, etc.).

Here are a few reasons to prefer the \code{[[} operator over \code{[} or \code{$} when you want to extract
an element from a data frame or a list:
\itemize{
\item Subsetting a list with \code{[} always returns a smaller list, while \code{[[} returns
the list element.
\item Subsetting a named atomic vector with \code{[} returns a named vector, while \code{[[} returns
the vector element.
\item Subsetting a data frame (but not tibble) with \code{[} is type unstable; it can return
a vector or a data frame. \code{[[}, on the other hand, always returns a vector.
\item For a data frame (but not tibble), \code{$} does partial matching (e.g. \code{df$a} will subset
\code{df$abc}), which can be a source of bugs. \code{[[} doesn't do partial matching.
}

For data frames (and tibbles), irrespective of the size, the \code{[[} operator is slower than \code{$}.
For lists, however, the reverse is true.
}
\examples{
# will produce lints
lint(
  text = 'iris["Species"]',
  linters = extraction_operator_linter()
)

lint(
  text = "iris$Species",
  linters = extraction_operator_linter()
)

# okay
lint(
  text = 'iris[["Species"]]',
  linters = extraction_operator_linter()
)

}
\references{
\itemize{
\item Subsetting \href{https://adv-r.hadley.nz/subsetting.html}{chapter} from \emph{Advanced R} (Wickham, 2019).
}
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=style_linters]{style}
}
