% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLoss.R
\name{logLoss}
\alias{logLoss}
\alias{logLoss.default}
\alias{logLoss.glm}
\alias{logLoss.randomForest}
\alias{logLoss.glmerMod}
\alias{logLoss.gbm}
\alias{logLoss.rpart}
\title{Log Loss}
\usage{
logLoss(...)

\method{logLoss}{default}(actual, predicted, distribution = "binomial", ...)

\method{logLoss}{glm}(modelObject, ...)

\method{logLoss}{randomForest}(modelObject, ...)

\method{logLoss}{glmerMod}(modelObject, ...)

\method{logLoss}{gbm}(modelObject, ...)

\method{logLoss}{rpart}(modelObject, ...)
}
\arguments{
\item{\dots}{additional parameters to be passed the the s3 methods}

\item{actual}{a binary vector of the labels}

\item{predicted}{a vector of predicted values}

\item{distribution}{the distribution of the loss function needed \code{binomial, poisson}}

\item{modelObject}{the model object. Currently supported \code{glm, randomForest, glmerMod, gbm}}
}
\description{
Calculates the log loss or entropy loss for a binary outcome
}
\examples{
data(testDF)
glmModel <- glm(y ~ ., data = testDF, family="binomial")
Preds <- predict(glmModel, type = 'response')

logLoss(testDF$y, Preds)
# using s3 method for glm
logLoss(glmModel)

}
