% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hshrink.R
\name{hshrink}
\alias{hshrink}
\title{Hierarchical shrinkage}
\usage{
hshrink(rf, lambda)
}
\arguments{
\item{rf}{ranger object, created with \code{node.stats = TRUE}.}

\item{lambda}{Non-negative shrinkage parameter.}
}
\value{
The ranger object is modified in-place.
}
\description{
Apply hierarchical shrinkage to a ranger object. 
Hierarchical shrinkage is a regularization technique that recursively shrinks node predictions towards parent node predictions. 
For details see Agarwal et al. (2022).
}
\examples{
## Hierarchical shrinkage for a probablity forest
rf <- ranger(Species ~ ., iris, node.stats = TRUE, probability = TRUE)
hshrink(rf, lambda = 5)
}
\references{
\itemize{
  \item Agarwal, A., Tan, Y.S., Ronen, O., Singh, C. & Yu, B. (2022). Hierarchical Shrinkage: Improving the accuracy and interpretability of tree-based models. Proceedings of the 39th International Conference on Machine Learning, PMLR 162:111-135.
  }
}
\author{
Marvin N. Wright
}
