\name{RGB}

\docType{methods}

\alias{RGB}
\alias{RGB,RasterLayer-method}

\title{Create a Red-Green-Blue Raster object}

\description{
Make a Red-Green-Blue object that can be used to create images. 
}


\usage{
\S4method{RGB}{RasterLayer}(x, filename='', col=rainbow(25), breaks=NULL, alpha=FALSE, 
		colNA='white', zlim=NULL, zlimcol=NULL, ext=NULL, ...)
}

\arguments{
  \item{x}{RasterBrick or RasterStack}
  \item{filename}{character. Output filename (optional)}
  \item{col}{A color palette, that is a vector of n contiguous colors generated by functions like \link{rainbow}, \link{heat.colors}, \link{topo.colors}, \link[sp]{bpy.colors} or one or your own making, perhaps using \code{\link{colorRampPalette}}. If none is provided, \code{rev(terrain.colors(255))} is used unless \code{x} has a 'color table'}
  \item{breaks}{numeric. A set of finite numeric breakpoints for the colours: must have one more breakpoint than colour and be in increasing order}  
  \item{alpha}{If \code{TRUE} a fourth layer to set the background transparency is added}
  \item{colNA}{color for the background (\code{NA} values)}
  \item{zlim}{vector of lenght 2. Range of values to plot}
  \item{zlimcol}{If \code{NULL} the values outside the range of zlim get the color of the extremes of the range. If zlimcol has any other value, the values outside the zlim range get the color of \code{NA} values (see colNA)}
  \item{ext}{An \code{\link{Extent}} object to zoom in to a region of interest (see \code{\link{drawExtent}})}
  \item{...}{additional arguments as for \code{\link{writeRaster}}}
}


\seealso{ \code{\link[raster]{plotRGB}} }

\examples{
r <- raster(system.file("external/test.grd", package="raster"))
x <- RGB(r)
plot(x, col=gray(0:9/10))
plotRGB(x)
}

\keyword{methods}
\keyword{spatial}

