% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-na.R
\docType{data}
\name{missing}
\alias{missing}
\alias{na_lgl}
\alias{na_int}
\alias{na_dbl}
\alias{na_chr}
\alias{na_cpl}
\title{Missing values}
\format{An object of class \code{logical} of length 1.}
\usage{
na_lgl

na_int

na_dbl

na_chr

na_cpl
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("questioning")}

Missing values are represented in R with the general symbol
\code{NA}. They can be inserted in almost all data containers: all
atomic vectors except raw vectors can contain missing values. To
achieve this, R automatically converts the general \code{NA} symbol to a
typed missing value appropriate for the target vector. The objects
provided here are aliases for those typed \code{NA} objects.
}
\details{
Typed missing values are necessary because R needs sentinel values
of the same type (i.e. the same machine representation of the data)
as the containers into which they are inserted. The official typed
missing values are \code{NA_integer_}, \code{NA_real_}, \code{NA_character_} and
\code{NA_complex_}. The missing value for logical vectors is simply the
default \code{NA}. The aliases provided in rlang are consistently named
and thus simpler to remember. Also, \code{na_lgl} is provided as an
alias to \code{NA} that makes intent clearer.

Since \code{na_lgl} is the default \code{NA}, expressions such as \code{c(NA, NA)}
yield logical vectors as no data is available to give a clue of the
target type. In the same way, since lists and environments can
contain any types, expressions like \code{list(NA)} store a logical
\code{NA}.
}
\section{Life cycle}{


These shortcuts might be moved to the vctrs package at some
point. This is why they are marked as questioning.
}

\examples{
typeof(NA)
typeof(na_lgl)
typeof(na_int)

# Note that while the base R missing symbols cannot be overwritten,
# that's not the case for rlang's aliases:
na_dbl <- NA
typeof(na_dbl)
}
\keyword{datasets}
\keyword{internal}
