% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_grid.R
\name{st_make_grid}
\alias{st_make_grid}
\title{Create a regular tesselation over the bounding box of an sf or sfc object}
\usage{
st_make_grid(
  x,
  cellsize = c(diff(st_bbox(x)[c(1, 3)]), diff(st_bbox(x)[c(2, 4)]))/n,
  offset = st_bbox(x)[c("xmin", "ymin")],
  n = c(10, 10),
  crs = if (missing(x)) NA_crs_ else st_crs(x),
  what = "polygons",
  square = TRUE,
  flat_topped = FALSE
)
}
\arguments{
\item{x}{object of class \link{sf} or \link{sfc}}

\item{cellsize}{numeric of length 1 or 2 with target cellsize: for square or rectangular cells the width and height, for hexagonal cells the distance between opposite edges (edge length is cellsize/sqrt(3)). A length units object can be passed, or an area unit object with area size of the square or hexagonal cell.}

\item{offset}{numeric of length 2; lower left corner coordinates (x, y) of the grid}

\item{n}{integer of length 1 or 2, number of grid cells in x and y direction (columns, rows)}

\item{crs}{object of class \code{crs}; coordinate reference system of the target of the target grid in case argument \code{x} is missing, if \code{x} is not missing, its crs is inherited.}

\item{what}{character; one of: \code{"polygons"}, \code{"corners"}, or \code{"centers"}}

\item{square}{logical; if \code{FALSE}, create hexagonal grid}

\item{flat_topped}{logical; if \code{TRUE} generate flat topped hexagons, else generate pointy topped}
}
\value{
Object of class \code{sfc} (simple feature geometry list column) with, depending on \code{what} and \code{square},
square or hexagonal polygons, corner points of these polygons, or center points of these polygons.
}
\description{
Create a square or hexagonal grid covering the bounding box of the geometry of an sf or sfc object
}
\examples{
plot(st_make_grid(what = "centers"), axes = TRUE)
plot(st_make_grid(what = "corners"), add = TRUE, col = 'green', pch=3)
sfc = st_sfc(st_polygon(list(rbind(c(0,0), c(1,0), c(1,1), c(0,0)))))
plot(st_make_grid(sfc, cellsize = .1, square = FALSE))
plot(sfc, add = TRUE)
# non-default offset:
plot(st_make_grid(sfc, cellsize = .1, square = FALSE, offset = c(0, .05 / (sqrt(3)/2))))
plot(sfc, add = TRUE)
nc = st_read(system.file("shape/nc.shp", package="sf"))
g = st_make_grid(nc)
plot(g)
plot(st_geometry(nc), add = TRUE)
# g[nc] selects cells that intersect with nc:
plot(g[nc], col = '#ff000088', add = TRUE)
}
