% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_at.R
\name{tween_at}
\alias{tween_at}
\title{Get a specific position between two states}
\usage{
tween_at(from, to, at, ease)
}
\arguments{
\item{from, to}{A data.frame or vector of the same type. If either is of
length/nrow 1 it will get repeated to match the length of the other}

\item{at}{A numeric between 0 and 1 recycled to match the nrow/length of
\code{from}}

\item{ease}{A character vector giving valid easing functions. Recycled to
match the ncol of \code{from}}
}
\value{
If \code{from}/\code{to} is a data.frame then a data.frame with the same
columns. If \code{from}/\code{to} is a vector then a vector.
}
\description{
This tween allows you to query a specific postion between two states rather
than generate evenly spaced states. It can work with either data.frames or
single vectors and each row/element can have its own position and easing.
}
\examples{
tween_at(mtcars[1:6, ], mtcars[6:1, ], runif(6), 'cubic-in-out')

}
