% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persisters-file.R
\name{FileSystem}
\alias{FileSystem}
\title{File system persister}
\description{
The only built-in cassette persister. Persists cassettes
to the file system.
}
\details{
\strong{Private Methods}
\describe{
\item{\code{storage_location()}}{
Get storage location
}
\item{\code{absolute_path_to_file()}}{
Get absolute path to the \code{storage_location}
}
}
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())

(yy <- FileSystem$new(file_name = "file4014931b21b.yml"))
yy$set_cassette(content = "hello world!")

# is empty?
yy$is_empty()

# get cassette
yy$get_cassette(file_name = "file4014931b21b.yml")

# clenaup
unlink(file.path(tempdir(), "file4014931b21b.yml"))
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file_name}}{(character) the file name, not whole path}

\item{\code{write_fxn}}{(character) fxn to use for writing to disk}

\item{\code{content}}{(character) content to record to a cassette}

\item{\code{path}}{(character) storage directory for cassettes}

\item{\code{write2disk}}{(character) write to disk or make a new FileSystem}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FileSystem$new()}}
\item \href{#method-get_cassette}{\code{FileSystem$get_cassette()}}
\item \href{#method-is_empty}{\code{FileSystem$is_empty()}}
\item \href{#method-set_cassette}{\code{FileSystem$set_cassette()}}
\item \href{#method-clone}{\code{FileSystem$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{FileSystem} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileSystem$new(
  file_name = NULL,
  write_fxn = NULL,
  content = NULL,
  path = NULL,
  write2disk = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_name}}{(character) the file name, not whole path}

\item{\code{write_fxn}}{(character) fxn to use for writing to disk}

\item{\code{content}}{(character) content to record to a cassette}

\item{\code{path}}{(character) storage directory for cassettes}

\item{\code{write2disk}}{(logical) write to disk or just make a new FileSystem
object. Default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{FileSystem} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_cassette"></a>}}
\subsection{Method \code{get_cassette()}}{
Gets the cassette for the given storage key (file name)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileSystem$get_cassette(file_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_name}}{(character) the file name, not whole path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named list, from \code{yaml::yaml.load_file}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_empty"></a>}}
\subsection{Method \code{is_empty()}}{
Checks if a cassette is empty or not
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileSystem$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cassette"></a>}}
\subsection{Method \code{set_cassette()}}{
Sets the cassette for the given storage key (file name)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileSystem$set_cassette(file_name = NULL, content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_name}}{(character) the file name, not whole path}

\item{\code{content}}{(character) content to record to a cassette}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; writes to disk
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileSystem$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
