# ifndef _RHEOLEF_FORM_FIELD_EXPR_H
# define _RHEOLEF_FORM_FIELD_EXPR_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form.h"
#include "rheolef/field_component.h"
#include "rheolef/field_indirect.h"
#include "rheolef/field_expr.h"
namespace rheolef { 

// -----------------------------------------------------------------------
// form*field_expr
// -----------------------------------------------------------------------
#define _RHEOLEF_form_mult_field_var(field_var)				\
template <class T, class M>						\
inline									\
field_basic<T,M>							\
operator* (const form_basic<T,M>& a, const field_var<T,M>& expr)	\
{									\
  field_basic<T,M> xh = expr;						\
  return a.operator* (xh);						\
}
_RHEOLEF_form_mult_field_var(field_component)
_RHEOLEF_form_mult_field_var(field_component_const)
_RHEOLEF_form_mult_field_var(field_indirect)
_RHEOLEF_form_mult_field_var(field_indirect_const)
#undef _RHEOLEF_form_mult_field_var

template <class T, class M, class Expr>
inline
field_basic<T,M>
operator* (const form_basic<T,M>& a, const field_expr<Expr>& expr)
{
  field_basic<T,M> xh = expr;
  return a.operator* (xh);
}

}// namespace rheolef
# endif /* _RHEOLEF_FORM_FIELD_EXPR_H */
