require 'mime'
include MIME   # allow ommision of "MIME::" namespace in examples below

msg = Mail.new    # blank message with current date and message ID headers
msg.date -= 3600                        # change date to 1 hour ago
msg.subject = 'This is important'       # add subject
msg.headers.set('Priority', 'urgent')   # add custom header

msg.body = Text.new('hello, world!', 'plain', 'charset' => 'us-ascii')
#
# The previous line is equivalent to the following snippet:
#
#   msg.body = 'hello, world!'
#   msg.headers.set('Content-Type', 'text/plain; charset=us-ascii')

msg.from = {'boss@example.com' => 'Boss Man'}            # mailbox hash
msg.bcc  = 'boss+home@example.com'                       # mailbox string
msg.cc   = %w(secretary@example.com manager@example.com) # mailbox array
msg.to   = {
  'list@example.com' => nil,                             # no name display
  'john@example.com' => 'John Doe',
  'jane@example.com' => 'Jane Doe',
}

msg.to_s  # ready to be sent via SMTP
